/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.common;

import com.google.common.collect.FluentIterable;
import com.google.inject.Injector;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xpect.XpectFile;
import org.eclipse.xpect.XpectJavaModel;
import org.eclipse.xpect.state.StateContainer;
import org.eclipse.xpect.util.IXtInjectorProvider;
import org.eclipse.xpect.xtext.lib.setup.FileSetupContext;
import org.eclipse.xtext.resource.IResourceFactory;

public class DuplicateResourceAwareFileSetupContext
extends FileSetupContext {
    private final FileSetupContext context;

    public DuplicateResourceAwareFileSetupContext(FileSetupContext context) {
        super(context.getState(), context.getXpectFile());
        this.context = context;
    }

    public FileSetupContext create() {
        return this.context.create();
    }

    public <T> T get(Class<T> expectedType, Object ... annotations) {
        return (T)this.context.get(expectedType, annotations);
    }

    public StateContainer getState() {
        return this.context.getState();
    }

    public XpectFile getXpectFile() {
        return this.context.getXpectFile();
    }

    public URI getXpectFileURI() {
        return this.context.getXpectFileURI();
    }

    public Resource load(ResourceSet resourceSet, URI uri, InputStream input) throws IOException {
        Injector injector = IXtInjectorProvider.INSTANCE.getInjector((XpectJavaModel)this.context.get(XpectJavaModel.class, new Object[0]), uri);
        Resource resource = ((IResourceFactory)injector.getInstance(IResourceFactory.class)).createResource(uri);
        Resource existingResousce = (Resource)FluentIterable.from((Iterable)resourceSet.getResources()).firstMatch(r -> r.getURI().equals(resource.getURI())).orNull();
        if (existingResousce != null) {
            resourceSet.getResources().remove((Object)existingResousce);
        }
        resourceSet.getResources().add((Object)resource);
        try {
            resource.load(input, null);
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
        return resource;
    }

    public int hashCode() {
        return this.context.hashCode();
    }

    public URI resolve(String uri) {
        return this.context.resolve(uri);
    }

    public String toString() {
        return this.context.toString();
    }

    public boolean equals(Object obj) {
        return this.context.equals(obj);
    }
}

