/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.methods;

import com.google.inject.Inject;
import junit.framework.AssertionFailedError;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.ts.types.TMigration;
import org.eclipse.n4js.xpect.common.N4JSOffsetAdapter;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.expectation.IStringExpectation;
import org.eclipse.xpect.expectation.StringExpectation;
import org.eclipse.xpect.parameter.ParameterParser;
import org.eclipse.xpect.runner.Xpect;
import org.eclipse.xpect.xtext.lib.util.XtextOffsetAdapter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;

@XpectImport(value={N4JSOffsetAdapter.class})
public class MigrateScopeXpectMethod {
    @Inject
    private IScopeProvider scopeProvider;

    @ParameterParser(syntax="('at' arg1=OFFSET)?")
    @Xpect
    public void migrateScope(@StringExpectation IStringExpectation expectation, XtextOffsetAdapter.ICrossEReferenceAndEObject arg1) {
        if (expectation == null) {
            throw new IllegalStateException("No expectation specified, add '--> <migration name>'");
        }
        IScope scope = this.scopeProvider.getScope(arg1.getEObject(), arg1.getCrossEReference());
        IEObjectDescription description = scope.getSingleElement(QualifiedName.create((String)"migrate"));
        EObject migration = description.getEObjectOrProxy();
        if (!(migration instanceof TMigration)) {
            throw new AssertionFailedError("The statically linked function of the migrate calls is not a migration:" + migration);
        }
        expectation.assertEquals((Object)String.format("\"%s\"", ((TMigration)migration).getName()));
    }
}

