/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.methods;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.ts.typeRefs.Versionable;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.xpect.common.N4JSOffsetAdapter;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.expectation.IStringExpectation;
import org.eclipse.xpect.expectation.StringExpectation;
import org.eclipse.xpect.parameter.ParameterParser;
import org.eclipse.xpect.runner.Xpect;

@XpectImport(value={N4JSOffsetAdapter.class})
public class ModelVersionXpectMethod {
    @Inject
    private N4JSTypeSystem ts;

    @ParameterParser(syntax="('of' arg1=OFFSET)?")
    @Xpect
    public void version(@StringExpectation IStringExpectation expectation, N4JSOffsetAdapter.IEObjectCoveringRegion arg1) {
        if (expectation == null) {
            throw new IllegalStateException("No expectation specified, add '--> version'");
        }
        EObject object = arg1.getEObject();
        int actualVersion = this.getVersion(object);
        expectation.assertEquals((Object)this.toString(actualVersion));
    }

    private int getVersion(EObject object) {
        int _switchResult = 0;
        boolean _matched = false;
        if (object instanceof IdentifierRef) {
            _matched = true;
            return this.getVersion((EObject)((IdentifierRef)object).getId());
        }
        if (!_matched && object instanceof Type) {
            _matched = true;
            return ((Type)object).getVersion();
        }
        if (!_matched && object instanceof Versionable) {
            _matched = true;
            _switchResult = ((Versionable)object).getVersion();
        }
        if (!_matched && object instanceof TypableElement) {
            _matched = true;
            _switchResult = this.ts.tau((TypableElement)object).getVersion();
        }
        if (!_matched) {
            EClass _eClass = object.eClass();
            String _plus = "Cannot determine version of " + _eClass;
            throw new IllegalArgumentException(_plus);
        }
        return _switchResult;
    }

    private String toString(int version) {
        if (version == Integer.MAX_VALUE) {
            return "*";
        }
        return Integer.toString(version);
    }
}

