/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.antlr.syntaxcoloring;

import com.google.inject.Inject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xtext.generator.XtextGeneratorNaming;
import org.eclipse.xtext.xtext.generator.model.TypeReference;
import org.eclipse.xtext.xtext.generator.parser.antlr.AntlrGrammar;
import org.eclipse.xtext.xtext.generator.parser.antlr.GrammarNaming;

/**
 * Customized grammar naming applied in {@link N4JSAntlrHighlightingGrammarGenerator}.
 */
@SuppressWarnings("all")
public class N4JSHighlightingGrammarNaming extends GrammarNaming {
  @Inject
  @Extension
  private XtextGeneratorNaming _xtextGeneratorNaming;
  
  @Override
  protected String getParserPackage(final Grammar it) {
    StringConcatenation _builder = new StringConcatenation();
    String _eclipsePluginBasePackage = this._xtextGeneratorNaming.getEclipsePluginBasePackage(it);
    _builder.append(_eclipsePluginBasePackage);
    _builder.append(".editor.syntaxcoloring");
    return _builder.toString();
  }
  
  @Override
  protected String getInternalLexerPackage(final Grammar it) {
    String _runtimeBasePackage = this._xtextGeneratorNaming.getRuntimeBasePackage(it);
    return (_runtimeBasePackage + ".lexer");
  }
  
  @Override
  public AntlrGrammar getLexerGrammar(final Grammar it) {
    String _internalLexerPackage = this.getInternalLexerPackage(it);
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Internal");
    String _simpleName = GrammarUtil.getSimpleName(it);
    _builder.append(_simpleName);
    _builder.append("Lexer");
    return new AntlrGrammar(_internalLexerPackage, _builder.toString());
  }
  
  @Override
  public AntlrGrammar getParserGrammar(final Grammar it) {
    String _parserPackage = this.getParserPackage(it);
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Internal");
    String _simpleName = GrammarUtil.getSimpleName(it);
    _builder.append(_simpleName);
    _builder.append("Parser");
    return new AntlrGrammar(_parserPackage, _builder.toString());
  }
  
  @Override
  public TypeReference getInternalParserSuperClass(final Grammar it) {
    return new TypeReference("org.eclipse.n4js.ui.editor.syntaxcoloring.AbstractInternalHighlightingAntlrParser");
  }
}
