/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.runner.nodejs;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.n4js.binaries.Binary;
import org.eclipse.n4js.binaries.IllegalBinaryStateException;
import org.eclipse.n4js.binaries.nodejs.NodeJsBinary;
import org.eclipse.n4js.runner.IExecutor;
import org.eclipse.n4js.runner.IRunner;
import org.eclipse.n4js.runner.RunConfiguration;
import org.eclipse.n4js.runner.RunnerFileBasedShippedCodeConfigurationHelper;
import org.eclipse.n4js.runner.SystemLoaderInfo;
import org.eclipse.n4js.runner.extension.IRunnerDescriptor;
import org.eclipse.n4js.runner.extension.RunnerDescriptorImpl;
import org.eclipse.n4js.runner.extension.RuntimeEnvironment;
import org.eclipse.n4js.runner.nodejs.NodeEngineCommandBuilder;
import org.eclipse.n4js.runner.nodejs.NodeRunOptions;
import org.eclipse.n4js.utils.io.FileUtils;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class NodeRunner
implements IRunner {
    private static final String NODE_PATH_SEP = File.pathSeparator;
    private static final String NODE_PATH = "NODE_PATH";
    private static final Logger LOGGER = Logger.getLogger(NodeRunner.class);
    public static final String ID = "org.eclipse.n4js.runner.nodejs.NODEJS";
    public static final IRunnerDescriptor DESCRIPTOR = new RunnerDescriptorImpl("org.eclipse.n4js.runner.nodejs.NODEJS", "Node.js Runner", RuntimeEnvironment.NODEJS, (IRunner)new NodeRunner());
    @Inject
    private Provider<NodeEngineCommandBuilder> commandBuilderProvider;
    @Inject
    private Provider<NodeJsBinary> nodeJsBinaryProvider;
    @Inject
    private RunnerFileBasedShippedCodeConfigurationHelper shippedCodeConfigurationHelper;
    @Inject
    private Provider<NodeRunOptions> nodeRunOptionsProvider;

    public RunConfiguration createConfiguration() {
        return new RunConfiguration();
    }

    public void prepareConfiguration(RunConfiguration config) {
        if (config.isUseCustomBootstrap()) {
            this.shippedCodeConfigurationHelper.configureFromFileSystem(config);
        }
    }

    public Process run(RunConfiguration runConfig, IExecutor executor) {
        NodeJsBinary nodeJsBinary = (NodeJsBinary)this.nodeJsBinaryProvider.get();
        IStatus status = nodeJsBinary.validate();
        if (!status.isOK()) {
            Exceptions.sneakyThrow((Throwable)new IllegalBinaryStateException((Binary)nodeJsBinary, status));
        }
        Process process = null;
        String[] cmds = new String[]{};
        try {
            NodeRunOptions runOptions = this.createRunOptions(runConfig);
            Path workingDirectory = FileUtils.createTempDirectory((String)"N4JSNodeRun");
            NodeEngineCommandBuilder cb = (NodeEngineCommandBuilder)this.commandBuilderProvider.get();
            cmds = cb.createCmds(runOptions, workingDirectory);
            LinkedHashSet paths = Sets.newLinkedHashSet();
            paths.addAll(Lists.newArrayList((Iterable)Splitter.on((String)NODE_PATH_SEP).omitEmptyStrings().trimResults().split((CharSequence)runConfig.getCustomEnginePath())));
            if (runConfig.getAdditionalPath() != null && !runConfig.getAdditionalPath().isEmpty()) {
                paths.add(runConfig.getAdditionalPath());
            }
            paths.add(workingDirectory.resolve("node_modules").toAbsolutePath().toString());
            String nodePaths = Joiner.on((String)NODE_PATH_SEP).join((Iterable)paths);
            Map<String, String> env = new LinkedHashMap<String, String>();
            env.putAll(runOptions.getEnvironmentVariables());
            env.put(NODE_PATH, nodePaths);
            env = nodeJsBinary.updateEnvironment(env);
            process = executor.exec(cmds, workingDirectory.toFile(), env);
        }
        catch (IOException | RuntimeException | ExecutionException e) {
            LOGGER.error((Object)e);
        }
        return process;
    }

    protected NodeRunOptions createRunOptions(RunConfiguration runConfig) {
        NodeRunOptions runOptions = (NodeRunOptions)this.nodeRunOptionsProvider.get();
        runOptions.setExecModule(runConfig.getExecModule());
        runOptions.addInitModules(runConfig.getInitModules());
        runOptions.setCoreProjectPaths(runConfig.getCoreProjectPaths());
        runOptions.setEngineOptions(runConfig.getEngineOptions());
        runOptions.setEnvironmentVariables(runConfig.getEnvironmentVariables());
        runOptions.setCustomEnginePath(runConfig.getCustomEnginePath());
        runOptions.setExecutionData(runConfig.getExecutionDataAsJSON());
        runOptions.setSystemLoader(SystemLoaderInfo.fromString((String)runConfig.getSystemLoader()));
        return runOptions;
    }

    public static final class NodeRunnerDescriptorProvider
    implements Provider<IRunnerDescriptor> {
        @Inject
        private Provider<NodeRunner> nodeRunnerProvider;

        public IRunnerDescriptor get() {
            return new RunnerDescriptorImpl(NodeRunner.ID, "Node.js Runner", RuntimeEnvironment.NODEJS, (IRunner)this.nodeRunnerProvider.get());
        }
    }
}

