/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.typesbuilder;

import com.google.inject.Inject;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesbuilder.N4JSTypesBuilderHelper;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
class N4JSFieldTypesBuilder {
  @Inject
  @Extension
  private N4JSTypesBuilderHelper _n4JSTypesBuilderHelper;
  
  boolean relinkField(final N4FieldDeclaration n4Field, final TClassifier classifierType, final boolean preLinkingPhase, final int idx) {
    if (((n4Field.getName() == null) && (!n4Field.hasComputedPropertyName()))) {
      return false;
    }
    TMember _get = classifierType.getOwnedMembers().get(idx);
    final TField field = ((TField) _get);
    this._n4JSTypesBuilderHelper.ensureEqualName(n4Field, field);
    field.setAstElement(n4Field);
    n4Field.setDefinedField(field);
    return true;
  }
  
  TField createField(final N4FieldDeclaration n4Field, final TClassifier classifierType, final boolean preLinkingPhase) {
    if (((n4Field.getName() == null) && (!n4Field.hasComputedPropertyName()))) {
      return null;
    }
    final TField field = TypesFactory.eINSTANCE.createTField();
    this._n4JSTypesBuilderHelper.setMemberName(field, n4Field);
    field.setConst(n4Field.isConst());
    field.setDeclaredStatic(n4Field.isDeclaredStatic());
    field.setDeclaredFinal(n4Field.isDeclaredFinal());
    field.setOptional(n4Field.isDeclaredOptional());
    field.setDeclaredOverride(AnnotationDefinition.OVERRIDE.hasAnnotation(n4Field));
    final boolean providesInitializer = AnnotationDefinition.PROVIDES_INITIALZER.hasAnnotation(n4Field);
    field.setHasExpression(((n4Field.getExpression() != null) || providesInitializer));
    this._n4JSTypesBuilderHelper.copyAnnotations(field, n4Field, preLinkingPhase);
    this.setMemberAccessModifier(field, n4Field);
    this.setFieldType(field, n4Field, preLinkingPhase);
    field.setAstElement(n4Field);
    n4Field.setDefinedField(field);
    return field;
  }
  
  private void setFieldType(final TField field, final N4FieldDeclaration n4Field, final boolean preLinkingPhase) {
    if ((!preLinkingPhase)) {
      TypeRef _declaredTypeRef = n4Field.getDeclaredTypeRef();
      boolean _tripleNotEquals = (_declaredTypeRef != null);
      if (_tripleNotEquals) {
        field.setTypeRef(TypeUtils.<TypeRef>copyWithProxies(n4Field.getDeclaredTypeRef()));
      } else {
        field.setTypeRef(TypeUtils.createDeferredTypeRef());
      }
    }
  }
  
  private void setMemberAccessModifier(final TField fieldType, final N4FieldDeclaration n4Field) {
    final Procedure1<MemberAccessModifier> _function = (MemberAccessModifier modifier) -> {
      fieldType.setDeclaredMemberAccessModifier(modifier);
    };
    this._n4JSTypesBuilderHelper.setMemberAccessModifier(_function, 
      n4Field.getDeclaredModifiers(), n4Field.getAnnotations());
  }
}
