/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.tests.codegen;

import java.util.List;
import java.util.Objects;
import org.eclipse.n4js.tests.codegen.Member;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.StringExtensions;

/**
 * Code generator for member methods of a {@link Classifier}.
 */
@SuppressWarnings("all")
public class Method extends Member<Method> {
  /**
   * A method parameter specification.
   */
  public static class Param {
    private String type;
    
    private String name;
    
    /**
     * Creates a new instance with the given type and name.
     * 
     * @param type the parameter type
     * @param name the parameter name
     */
    public Param(final String type, final String name) {
      this.type = type;
      this.name = name;
    }
  }
  
  private String returnType;
  
  private List<Method.Param> params;
  
  private String body;
  
  /**
   * Creates a new instance with the given parameters.
   * 
   * @param name the method name
   */
  public Method(final String name) {
    super(name);
  }
  
  /**
   * Sets the return type of this method.
   * 
   * @param returnType the return type
   */
  public Method setReturnType(final String returnType) {
    this.returnType = returnType;
    return this;
  }
  
  /**
   * Adds a parameter to this method.
   * 
   * @param param the parameter to add
   */
  public Method addParameter(final Method.Param param) {
    if ((this.params == null)) {
      this.params = CollectionLiterals.<Method.Param>newLinkedList();
    }
    this.params.add(Objects.<Method.Param>requireNonNull(param));
    return this;
  }
  
  /**
   * Sets the body of this method.
   * 
   * @param body the body to set
   */
  public Method setBody(final String body) {
    this.body = body;
    return this;
  }
  
  @java.lang.Override
  protected CharSequence generateMember() {
    StringConcatenation _builder = new StringConcatenation();
    String _generateAbstract = this.generateAbstract();
    _builder.append(_generateAbstract);
    _builder.append(this.name);
    _builder.append("(");
    {
      if ((this.params != null)) {
        {
          for(final Method.Param p : this.params) {
            _builder.append(p.name);
            _builder.append(": ");
            _builder.append(p.type);
          }
        }
      }
    }
    _builder.append(")");
    {
      boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(this.returnType);
      boolean _not = (!_isNullOrEmpty);
      if (_not) {
        _builder.append(": ");
        _builder.append(this.returnType);
      }
    }
    {
      boolean _isAbstract = this.isAbstract();
      if (_isAbstract) {
        _builder.append(";");
      } else {
        _builder.append(" ");
        {
          boolean _hasBody = this.hasBody();
          boolean _not_1 = (!_hasBody);
          if (_not_1) {
            _builder.append("{}");
          } else {
            _builder.append("{");
            _builder.newLineIfNotEmpty();
            {
              boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty(this.body);
              boolean _not_2 = (!_isNullOrEmpty_1);
              if (_not_2) {
                _builder.append("\t");
                _builder.append(this.body, "\t");
                _builder.newLineIfNotEmpty();
              } else {
                boolean _isNullOrEmpty_2 = StringExtensions.isNullOrEmpty(this.returnType);
                boolean _not_3 = (!_isNullOrEmpty_2);
                if (_not_3) {
                  _builder.append("\t");
                  _builder.append("return new ");
                  _builder.append(this.returnType, "\t");
                  _builder.append("()");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
            _builder.append("}");
          }
        }
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  private boolean hasBody() {
    return ((!StringExtensions.isNullOrEmpty(this.body)) || (!StringExtensions.isNullOrEmpty(this.returnType)));
  }
}
