/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.preferences.external;

import java.util.function.BiFunction;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.n4js.ui.internal.N4JSActivator;
import org.eclipse.n4js.ui.preferences.external.MaintenanceActionsChoice;
import org.eclipse.n4js.ui.utils.UIUtils;
import org.eclipse.n4js.utils.StatusHelper;
import org.eclipse.n4js.utils.StatusUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class MaintenanceActionsButtonListener
extends SelectionAdapter {
    private final BiFunction<MaintenanceActionsChoice, IProgressMonitor, MultiStatus> runActions;
    private final StatusHelper statusHelper;
    static final String ACTION_NPM_RELOAD = "Re-register all npms (cleans and builds npms from disk).";
    static final String ACTION_NPM_REINSTALL = "Reinstall npm libraries.";
    static final String ACTION_NPM_CACHE_CLEAN = "Clean npm cache. (npm cache clean --force)";
    static final String ACTION_NPM_PACKAGES_DELETE = "Delete all npms (deletes node_modules folder).";

    MaintenanceActionsButtonListener(BiFunction<MaintenanceActionsChoice, IProgressMonitor, MultiStatus> runActions, StatusHelper statusHelper) {
        this.runActions = runActions;
        this.statusHelper = statusHelper;
    }

    public void widgetSelected(SelectionEvent e) {
        block28: {
            String[] options = new String[]{ACTION_NPM_CACHE_CLEAN, ACTION_NPM_RELOAD, ACTION_NPM_REINSTALL, ACTION_NPM_PACKAGES_DELETE};
            String msg = "Select maintenance actions to perform.";
            Shell shell = UIUtils.getShell();
            ArrayContentProvider contentProvider = ArrayContentProvider.getInstance();
            ListSelectionDialog dialog = new ListSelectionDialog(shell, (Object)options, (IStructuredContentProvider)contentProvider, (ILabelProvider)new LabelProvider(), msg);
            dialog.setTitle("External libraries maintenance actions.");
            if (dialog.open() != 0) break block28;
            boolean cleanCache = false;
            boolean deleteNPM = false;
            boolean reinstall = false;
            boolean reload = false;
            Object[] result = dialog.getResult();
            if (result == null) {
                return;
            }
            int i = 0;
            while (i < result.length) {
                String dialogItem;
                switch (dialogItem = (String)result[i]) {
                    case "Re-register all npms (cleans and builds npms from disk).": {
                        reload = true;
                        break;
                    }
                    case "Reinstall npm libraries.": {
                        reinstall = true;
                        break;
                    }
                    case "Clean npm cache. (npm cache clean --force)": {
                        cleanCache = true;
                        break;
                    }
                    case "Delete all npms (deletes node_modules folder).": {
                        deleteNPM = true;
                    }
                }
                ++i;
            }
            MaintenanceActionsChoice userChoice = new MaintenanceActionsChoice(cleanCache, reinstall, deleteNPM, reload);
            String statusText = "Perform Maintenance Actions: " + userChoice;
            MultiStatus multistatus = this.statusHelper.createMultiStatus(statusText);
            try {
                new ProgressMonitorDialog(shell).run(true, true, monitor -> multistatus.merge((IStatus)this.runActions.apply(userChoice, monitor)));
            }
            catch (InterruptedException | OperationCanceledException throwable) {
                if (!multistatus.isOK()) {
                    N4JSActivator.getInstance().getLog().log((IStatus)multistatus);
                    UIUtils.getDisplay().asyncExec(() -> {
                        String title = "Maintenance Action Failed";
                        String descr = StatusUtils.getErrorMessage((IStatus)multistatus, (boolean)true);
                        ErrorDialog.openError((Shell)shell, (String)title, (String)descr, (IStatus)multistatus);
                    });
                }
                break block28;
            }
            catch (Exception exc) {
                try {
                    String statusMsg = "Error while performing maintenance actions: " + userChoice + ".";
                    Throwable causingExc = exc.getCause() == null ? exc : exc.getCause();
                    multistatus.merge(this.statusHelper.createError(statusMsg, causingExc));
                }
                catch (Throwable throwable) {
                    if (!multistatus.isOK()) {
                        N4JSActivator.getInstance().getLog().log((IStatus)multistatus);
                        UIUtils.getDisplay().asyncExec(() -> {
                            String title = "Maintenance Action Failed";
                            String descr = StatusUtils.getErrorMessage((IStatus)multistatus, (boolean)true);
                            ErrorDialog.openError((Shell)shell, (String)title, (String)descr, (IStatus)multistatus);
                        });
                    }
                    throw throwable;
                }
                if (!multistatus.isOK()) {
                    N4JSActivator.getInstance().getLog().log((IStatus)multistatus);
                    UIUtils.getDisplay().asyncExec(() -> {
                        String title = "Maintenance Action Failed";
                        String descr = StatusUtils.getErrorMessage((IStatus)multistatus, (boolean)true);
                        ErrorDialog.openError((Shell)shell, (String)title, (String)descr, (IStatus)multistatus);
                    });
                }
                break block28;
            }
            if (!multistatus.isOK()) {
                N4JSActivator.getInstance().getLog().log((IStatus)multistatus);
                UIUtils.getDisplay().asyncExec(() -> {
                    String title = "Maintenance Action Failed";
                    String descr = StatusUtils.getErrorMessage((IStatus)multistatus, (boolean)true);
                    ErrorDialog.openError((Shell)shell, (String)title, (String)descr, (IStatus)multistatus);
                });
            }
        }
    }
}

