/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.workspace;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.ui.wizard.workspace.WorkspaceWizardModel;
import org.eclipse.n4js.ui.wizard.workspace.WorkspaceWizardValidatorUtils;

public abstract class WorkspaceWizardModelValidator<M extends WorkspaceWizardModel> {
    public static final String VALIDATION_RESULT = "validationResult";
    public static final String PROJECT_PROPERTY_VALID = "projectValid";
    public static final String SOURCE_FOLDER_PROPERTY_VALID = "sourceFolderValid";
    private static final ValidationResult NO_MODEL_VALIDATION_RESULT = new ValidationResult("No model set");
    private ValidationResult validationResult;
    private boolean projectValid = false;
    private boolean sourceFolderValid = false;
    M model;
    @Inject
    private IN4JSCore n4jsCore;
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected M getModel() {
        return this.model;
    }

    public void setModel(M model) {
        this.model = model;
        this.setSourceFolderValid(false);
        this.setProjectValid(false);
        this.validate();
    }

    public final ValidationResult validate() {
        if (this.model == null) {
            this.setValidationResult(NO_MODEL_VALIDATION_RESULT);
            return NO_MODEL_VALIDATION_RESULT;
        }
        boolean success = true;
        this.prepare();
        try {
            this.run();
        }
        catch (ValidationException e) {
            this.setValidationResult(new ValidationResult(e.getMessage()));
            success = false;
        }
        catch (Exception e) {
            throw e;
        }
        if (success) {
            this.setValidationResult(ValidationResult.SUCCESS);
        }
        return this.validationResult;
    }

    protected void run() throws ValidationException {
        this.validateProject();
        this.validateSourceFolder();
        this.validateModuleSpecifier();
    }

    protected abstract void prepare();

    public ValidationResult getValidationResult() {
        return this.validationResult;
    }

    public boolean getProjectValid() {
        return this.projectValid;
    }

    private void setProjectValid(boolean projectValid) {
        this.projectValid = projectValid;
        this.firePropertyChange(PROJECT_PROPERTY_VALID, this.projectValid, this.projectValid);
    }

    public boolean getSourceFolderValid() {
        return this.sourceFolderValid;
    }

    private void setSourceFolderValid(boolean sourceFolderValid) {
        this.sourceFolderValid = sourceFolderValid;
        this.firePropertyChange(SOURCE_FOLDER_PROPERTY_VALID, this.sourceFolderValid, this.sourceFolderValid);
    }

    private void setValidationResult(ValidationResult validationResult) {
        this.validationResult = validationResult;
        this.firePropertyChange(VALIDATION_RESULT, this.validationResult, this.validationResult);
    }

    private void validateProject() throws ValidationException {
        this.setProjectValid(false);
        if (((WorkspaceWizardModel)this.getModel()).getProject().toString().trim().isEmpty()) {
            throw new ValidationException("The project field must not be empty", "project");
        }
        URI projectURI = URI.createPlatformResourceURI((String)((WorkspaceWizardModel)this.getModel()).getProject().toString(), (boolean)true);
        Optional n4jsProject = this.n4jsCore.findProject(projectURI);
        if (!n4jsProject.isPresent()) {
            throw new ValidationException("Not a valid project", "project");
        }
        if (!((IN4JSProject)n4jsProject.get()).exists()) {
            throw new ValidationException("The given project does not exist", "project");
        }
        if (!((IN4JSProject)n4jsProject.get()).getLocation().equals(projectURI)) {
            throw new ValidationException("Not a valid project" + ((IN4JSProject)n4jsProject.get()).getLocation(), "project");
        }
        this.setProjectValid(true);
    }

    private void validateSourceFolder() throws ValidationException {
        this.setSourceFolderValid(false);
        String sourceFolder = ((WorkspaceWizardModel)this.getModel()).getSourceFolder().removeTrailingSeparator().toString();
        if (sourceFolder.trim().isEmpty()) {
            throw new ValidationException("The source folder field must not be empty", "sourceFolder");
        }
        if (!WorkspaceWizardValidatorUtils.isValidFolderPath(((WorkspaceWizardModel)this.getModel()).getSourceFolder())) {
            throw new ValidationException("The source folder is not a valid folder name", "sourceFolder");
        }
        URI projectUri = URI.createPlatformResourceURI((String)((WorkspaceWizardModel)this.getModel()).getProject().segment(0), (boolean)true);
        IN4JSProject project = (IN4JSProject)this.n4jsCore.findProject(projectUri).orNull();
        if (project == null) {
            throw new ValidationException("Invalid state validation error");
        }
        if (project.getSourceContainers().stream().filter(src -> src.isSource() || src.isTest()).filter(src -> src.getRelativeLocation().equals(sourceFolder)).count() == 0L) {
            throw new ValidationException("The source folder does not exist", "sourceFolder");
        }
        this.setSourceFolderValid(true);
    }

    protected void validateModuleSpecifier() throws ValidationException {
        this.doValidateModuleSpecifier(((WorkspaceWizardModel)this.getModel()).getModuleSpecifier());
    }

    protected void doValidateModuleSpecifier(String moduleSpecifier) throws ValidationException {
        if (moduleSpecifier.trim().isEmpty()) {
            throw new ValidationException("The module specifier field must not be empty", "moduleSpecifier");
        }
        String[] moduleSpecifierSegments = moduleSpecifier.split("/", -1);
        int i = 0;
        while (i < moduleSpecifierSegments.length) {
            String segment = moduleSpecifierSegments[i];
            boolean last = i == moduleSpecifierSegments.length - 1;
            boolean first = i == 0;
            boolean empty = segment.trim().isEmpty();
            if (first && empty) {
                throw new ValidationException("Invalid module specifier. Must not begin with a \"/\" ", "moduleSpecifier");
            }
            if (empty && !last) {
                throw new ValidationException("Invalid module specifier. Empty path segment:", "moduleSpecifier");
            }
            if (!(WorkspaceWizardValidatorUtils.isValidFolderName(segment) || empty && last)) {
                throw new ValidationException("Invalid module specifier. Invalid segment. ", "moduleSpecifier");
            }
            ++i;
        }
    }

    protected static class ErrorMessages {
        public static final String INVALID_STATE_VALIDATION_ERROR = "Invalid state validation error";
        public static final String PROJECT_DOES_NOT_EXIST = "The given project does not exist";
        public static final String INVALID_PROJECT = "Not a valid project";
        public static final String PROJECT_MUST_NOT_BE_EMPTY = "The project field must not be empty";
        public static final String SOURCE_FOLDER_MUST_NOT_BE_EMPTY = "The source folder field must not be empty";
        public static final String SOURCE_FOLDER_IS_NOT_A_VALID_FOLDER_NAME = "The source folder is not a valid folder name";
        public static final String SOURCE_FOLDER_DOES_NOT_EXIST = "The source folder does not exist";
        public static final String MODULE_SPECIFIER_MUST_NOT_BE_EMPTY = "The module specifier field must not be empty";
        public static final String INVALID_MODULE_SPECIFIER_MUST_NOT_BEGIN_WITH = "Invalid module specifier. Must not begin with a \"/\" ";
        public static final String INVALID_MODULE_SPECIFIER_EMPTY_PATH_SEGMENT = "Invalid module specifier. Empty path segment:";
        public static final String INVALID_MODULE_SPECIFIER_INVALID_SEGMENT = "Invalid module specifier. Invalid segment. ";

        protected ErrorMessages() {
        }
    }

    protected static class ValidationException
    extends Exception {
        private final String propertyName = "";

        public ValidationException(String message) {
            super(message);
        }

        public ValidationException(String message, String propertyName) {
            super(message);
        }

        public String getPropertyName() {
            return "";
        }
    }

    public static class ValidationResult {
        public static final ValidationResult SUCCESS = new ValidationResult();
        public final boolean valid;
        public final String errorMessage;

        public ValidationResult() {
            this.valid = true;
            this.errorMessage = "";
        }

        public ValidationResult(String errorMessage) {
            this.valid = false;
            this.errorMessage = errorMessage;
        }
    }
}

