/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.workingsets;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.n4js.ui.workingsets.WorkingSet;
import org.eclipse.n4js.ui.workingsets.WorkingSetDiffBuilder;
import org.eclipse.n4js.ui.workingsets.WorkingSetManager;
import org.eclipse.n4js.ui.workingsets.WorkingSetManagerModificationStrategyImpl;
import org.eclipse.n4js.utils.Diff;
import org.eclipse.ui.IWorkingSet;

public class RemoveWorkingSetModificationStrategy
extends WorkingSetManagerModificationStrategyImpl {
    private final IWorkingSet toRemove;

    public RemoveWorkingSetModificationStrategy(IWorkingSet toRemoved) {
        this.toRemove = toRemoved;
    }

    @Override
    public void execute(WorkingSetManager manager) {
        if (this.toRemove != null && "org.eclipse.ui.resourceWorkingSetPage".equals(this.toRemove.getId())) {
            String name = this.toRemove.getName();
            WorkingSet workingSet = this.getWorkingSetByName(manager, name);
            if (workingSet == null) {
                return;
            }
            WorkingSetDiffBuilder builder = new WorkingSetDiffBuilder(manager);
            builder.delete(workingSet);
            ArrayList newAllItems = Lists.newArrayList((Object[])manager.getAllWorkingSets());
            newAllItems.remove(workingSet);
            ArrayList newItems = Lists.newArrayList((Object[])manager.getWorkingSets());
            newItems.remove(workingSet);
            Diff<WorkingSet> diff = builder.build(newItems, newAllItems);
            this.updateAndSaveState(manager, diff);
        }
    }
}

