/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.ui.results;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.n4js.xpect.ui.N4IDEXpectUIPlugin;
import org.eclipse.n4js.xpect.ui.results.ExecutionResults;
import org.eclipse.n4js.xpect.ui.results.ExecutionStatus;
import org.eclipse.n4js.xpect.ui.results.XpectFileContentsUtil;
import org.eclipse.n4js.xpect.ui.runner.N4IDEXpectFileNameUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.junit.runner.Description;

class XpectLabelProvider
extends LabelProvider {
    private final Map<ImageDescriptor, Image> imageCache = new HashMap<ImageDescriptor, Image>();
    private final ExecutionResults executionStatus;

    XpectLabelProvider(ExecutionResults testTreeExecutionStatus) {
        this.executionStatus = testTreeExecutionStatus;
    }

    public String getText(Object element) {
        if (!(element instanceof Description)) {
            return "";
        }
        Description desc = (Description)element;
        if (desc.isSuite()) {
            return N4IDEXpectFileNameUtil.getSuiteName(desc);
        }
        if (desc.isTest()) {
            return N4IDEXpectFileNameUtil.getTestName(desc);
        }
        return "";
    }

    public Image getImage(Object element) {
        ImageDescriptor descriptor = this.getImageDescriptor(element);
        if (descriptor == null) {
            return null;
        }
        Image image = this.imageCache.get(descriptor);
        if (image == null) {
            image = descriptor.createImage();
            this.imageCache.put(descriptor, image);
        }
        return image;
    }

    private ImageDescriptor getImageDescriptor(Object element) throws RuntimeException {
        ImageDescriptor descriptor = null;
        if (!(element instanceof Description)) {
            String msg = "Unknown type of element in tree of type " + element.getClass().getName();
            RuntimeException e = new RuntimeException(msg);
            N4IDEXpectUIPlugin.logError("cannot obtain image descriptor, fallback to default", e);
            return XpectLabelProvider.getImageDescriptor("n4_logo.png");
        }
        Description desc = (Description)element;
        descriptor = desc.isTest() ? this.getTestImageDescriptor(this.executionStatus.getStatus(desc)) : (desc.isSuite() ? this.getSuiteImageDescriptor(desc, this.executionStatus.getStatus(desc)) : XpectLabelProvider.getImageDescriptor("n4_logo.png"));
        return descriptor;
    }

    private ImageDescriptor getTestImageDescriptor(ExecutionStatus st) {
        ImageDescriptor descriptor;
        switch (st) {
            case PENDING: {
                descriptor = XpectLabelProvider.getImageDescriptor("test.png");
                break;
            }
            case STARTED: {
                descriptor = XpectLabelProvider.getImageDescriptor("test_running.png");
                break;
            }
            case IGNORED: {
                descriptor = XpectLabelProvider.getImageDescriptor("test_ignored.png");
                break;
            }
            case PASSED: {
                descriptor = XpectLabelProvider.getImageDescriptor("test_pass.png");
                break;
            }
            case FAILED: {
                descriptor = XpectLabelProvider.getImageDescriptor("test_fail.png");
                break;
            }
            case ERROR: {
                descriptor = XpectLabelProvider.getImageDescriptor("test_error.png");
                break;
            }
            default: {
                descriptor = XpectLabelProvider.getImageDescriptor("n4_logo.png");
            }
        }
        return descriptor;
    }

    private ImageDescriptor getSuiteImageDescriptor(Description desc, ExecutionStatus st) {
        ImageDescriptor descriptor;
        switch (st) {
            case PENDING: {
                descriptor = XpectLabelProvider.getImageDescriptor("testsuite.png");
                break;
            }
            case STARTED: {
                descriptor = XpectLabelProvider.getImageDescriptor("testsuite_running.png");
                break;
            }
            case IGNORED: {
                descriptor = XpectLabelProvider.getImageDescriptor("testsuite_ignored.png");
                break;
            }
            case PASSED: {
                descriptor = XpectLabelProvider.getImageDescriptor("testsuite_pass.png");
                Optional<XpectFileContentsUtil.XpectFileContentAccess> fileContentAccess = XpectFileContentsUtil.getXpectFileContentAccess(desc);
                if (!fileContentAccess.isPresent() || !fileContentAccess.get().containsFixme()) break;
                descriptor = XpectLabelProvider.getImageDescriptor("testsuite_fixme.png");
                break;
            }
            case FAILED: {
                descriptor = XpectLabelProvider.getImageDescriptor("testsuite_fail.png");
                break;
            }
            case ERROR: {
                descriptor = XpectLabelProvider.getImageDescriptor("testsuite_error.png");
                break;
            }
            default: {
                descriptor = XpectLabelProvider.getImageDescriptor("n4_logo.png");
            }
        }
        return descriptor;
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        String iconPath = "icons/";
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.n4js.xpect.ui", (String)(String.valueOf(iconPath) + name));
    }

    public void dispose() {
        Iterator<Image> i = this.imageCache.values().iterator();
        while (i.hasNext()) {
            i.next().dispose();
        }
        this.imageCache.clear();
    }
}

