/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.external;

import com.google.common.base.Preconditions;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class RebuildWorkspaceProjectsJob
extends WorkspaceJob {
    private static final Logger LOGGER = Logger.getLogger(RebuildWorkspaceProjectsJob.class);
    private static final ISchedulingRule BUILD_RULE = ResourcesPlugin.getWorkspace().getRuleFactory().buildRule();
    private final IBuildConfiguration[] configs;

    public RebuildWorkspaceProjectsJob(IBuildConfiguration[] configs) {
        super("Building workspace");
        Preconditions.checkState((boolean)Platform.isRunning(), (Object)"This job requires a running platform");
        this.configs = (IBuildConfiguration[])Preconditions.checkNotNull((Object)configs, (Object)"configs");
        this.setSystem(false);
        this.setUser(true);
        this.setRule(BUILD_RULE);
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        try {
            ResourcesPlugin.getWorkspace().build(this.configs, 15, false, monitor);
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            String message = "Error while rebuilding workspace content.";
            LOGGER.error((Object)"Error while rebuilding workspace content.", (Throwable)e);
            return new Status(4, "org.eclipse.n4js", "Error while rebuilding workspace content.", (Throwable)e);
        }
    }
}

