/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesbuilder;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.GenericDeclaration;
import org.eclipse.n4js.n4JS.N4ClassifierDeclaration;
import org.eclipse.n4js.n4JS.N4ClassifierDefinition;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4GetterDeclaration;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.N4SetterDeclaration;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.typesbuilder.N4JSFieldTypesBuilder;
import org.eclipse.n4js.typesbuilder.N4JSGetterTypesBuilder;
import org.eclipse.n4js.typesbuilder.N4JSMethodTypesBuilder;
import org.eclipse.n4js.typesbuilder.N4JSSetterTypesBuilder;
import org.eclipse.n4js.typesbuilder.N4JSTypesBuilderHelper;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

abstract class N4JSClassifierDeclarationTypesBuilder {
    @Inject
    @Extension
    protected N4JSTypesBuilderHelper _n4JSTypesBuilderHelper;
    @Inject
    @Extension
    protected N4JSFieldTypesBuilder _n4JSFieldTypesBuilder;
    @Inject
    @Extension
    protected N4JSMethodTypesBuilder _n4JSMethodTypesBuilder;
    @Inject
    @Extension
    protected N4JSGetterTypesBuilder _n4JSGetterTypesBuilder;
    @Inject
    @Extension
    protected N4JSSetterTypesBuilder _n4JSSetterTypesBuilder;

    N4JSClassifierDeclarationTypesBuilder() {
    }

    protected void addFields(TClassifier classifier, N4ClassifierDefinition definition, boolean preLinkingPhase) {
        Iterable n4Fields = Iterables.filter((Iterable)definition.getOwnedMembers(), N4FieldDeclaration.class);
        Functions.Function1 _function = it -> this._n4JSFieldTypesBuilder.createField((N4FieldDeclaration)it, classifier, preLinkingPhase);
        Iterable fields = IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)n4Fields, (Functions.Function1)_function));
        Iterables.addAll((Collection)classifier.getOwnedMembers(), (Iterable)fields);
    }

    protected void addMethods(TClassifier classifier, N4ClassifierDefinition definition, boolean preLinkingPhase) {
        Iterable n4Methods = Iterables.filter((Iterable)definition.getOwnedMembers(), N4MethodDeclaration.class);
        Functions.Function1 _function = it -> this._n4JSMethodTypesBuilder.createMethod((N4MethodDeclaration)it, preLinkingPhase);
        Iterable methods = IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)n4Methods, (Functions.Function1)_function));
        Iterables.addAll((Collection)classifier.getOwnedMembers(), (Iterable)methods);
        N4MethodDeclaration _ownedCallableCtor = definition.getOwnedCallableCtor();
        TMethod _createMethod = null;
        if (_ownedCallableCtor != null) {
            _createMethod = this._n4JSMethodTypesBuilder.createMethod(_ownedCallableCtor, preLinkingPhase);
        }
        classifier.setCallableCtor(_createMethod);
    }

    protected void addGetters(TClassifier classifier, N4ClassifierDefinition definition, boolean preLinkingPhase) {
        Iterable n4Getters = Iterables.filter((Iterable)definition.getOwnedMembers(), N4GetterDeclaration.class);
        Functions.Function1 _function = it -> this._n4JSGetterTypesBuilder.createGetter((N4GetterDeclaration)it, classifier, preLinkingPhase);
        Iterable getters = IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)n4Getters, (Functions.Function1)_function));
        Iterables.addAll((Collection)classifier.getOwnedMembers(), (Iterable)getters);
    }

    protected void addSetters(TClassifier classifier, N4ClassifierDefinition definition, boolean preLinkingPhase) {
        Iterable n4Setters = Iterables.filter((Iterable)definition.getOwnedMembers(), N4SetterDeclaration.class);
        Functions.Function1 _function = it -> this._n4JSSetterTypesBuilder.createSetter((N4SetterDeclaration)it, classifier, preLinkingPhase);
        Iterable setters = IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)n4Setters, (Functions.Function1)_function));
        Iterables.addAll((Collection)classifier.getOwnedMembers(), (Iterable)setters);
    }

    protected void addTypeParameters(TClassifier classifier, GenericDeclaration decl, boolean preLinkingPhase) {
        this._n4JSTypesBuilderHelper.addCopyOfReferences(classifier.getTypeVars(), decl.getTypeVars());
    }

    void relinkClassifierAndMembers(TClassifier classifier, N4ClassifierDeclaration declaration, boolean preLinkingPhase) {
        boolean _tripleNotEquals;
        this._n4JSTypesBuilderHelper.ensureEqualName((NamedElement)declaration, (IdentifiableElement)classifier);
        N4MethodDeclaration _ownedCallableCtor = declaration.getOwnedCallableCtor();
        boolean bl = _tripleNotEquals = _ownedCallableCtor != null;
        if (_tripleNotEquals) {
            this._n4JSMethodTypesBuilder.relinkCallableCtor(declaration.getOwnedCallableCtor(), classifier, preLinkingPhase);
        }
        int memberIdx = 0;
        memberIdx = this.relinkFields(classifier, (N4ClassifierDefinition)declaration, preLinkingPhase, memberIdx);
        memberIdx = this.relinkMethods(classifier, (N4ClassifierDefinition)declaration, preLinkingPhase, memberIdx);
        memberIdx = this.relinkGetters(classifier, (N4ClassifierDefinition)declaration, preLinkingPhase, memberIdx);
        memberIdx = this.relinkSetters(classifier, (N4ClassifierDefinition)declaration, preLinkingPhase, memberIdx);
        classifier.setAstElement((EObject)declaration);
        declaration.setDefinedType((Type)classifier);
    }

    protected int relinkFields(TClassifier classifier, N4ClassifierDefinition definition, boolean preLinkingPhase, int start) {
        Functions.Function2 _function = (idx, fld) -> {
            boolean _relinkField = this._n4JSFieldTypesBuilder.relinkField((N4FieldDeclaration)fld, classifier, preLinkingPhase, (int)idx);
            if (_relinkField) {
                return idx + 1;
            }
            return idx;
        };
        return (Integer)IterableExtensions.fold((Iterable)Iterables.filter((Iterable)definition.getOwnedMembers(), N4FieldDeclaration.class), (Object)start, (Functions.Function2)_function);
    }

    protected int relinkMethods(TClassifier classifier, N4ClassifierDefinition definition, boolean preLinkingPhase, int start) {
        Functions.Function2 _function = (idx, method) -> {
            boolean _relinkMethod = this._n4JSMethodTypesBuilder.relinkMethod((N4MethodDeclaration)method, classifier, preLinkingPhase, (int)idx);
            if (_relinkMethod) {
                return idx + 1;
            }
            return idx;
        };
        int result = (Integer)IterableExtensions.fold((Iterable)Iterables.filter((Iterable)definition.getOwnedMembers(), N4MethodDeclaration.class), (Object)start, (Functions.Function2)_function);
        return result;
    }

    protected int relinkGetters(TClassifier classifier, N4ClassifierDefinition definition, boolean preLinkingPhase, int start) {
        Functions.Function2 _function = (idx, getter) -> {
            boolean _relinkGetter = this._n4JSGetterTypesBuilder.relinkGetter((N4GetterDeclaration)getter, classifier, preLinkingPhase, (int)idx);
            if (_relinkGetter) {
                return idx + 1;
            }
            return idx;
        };
        return (Integer)IterableExtensions.fold((Iterable)Iterables.filter((Iterable)definition.getOwnedMembers(), N4GetterDeclaration.class), (Object)start, (Functions.Function2)_function);
    }

    protected int relinkSetters(TClassifier classifier, N4ClassifierDefinition definition, boolean preLinkingPhase, int start) {
        Functions.Function2 _function = (idx, setter) -> {
            boolean _relinkSetter = this._n4JSSetterTypesBuilder.relinkSetter((N4SetterDeclaration)setter, classifier, preLinkingPhase, (int)idx);
            if (_relinkSetter) {
                return idx + 1;
            }
            return idx;
        };
        return (Integer)IterableExtensions.fold((Iterable)Iterables.filter((Iterable)definition.getOwnedMembers(), N4SetterDeclaration.class), (Object)start, (Functions.Function2)_function);
    }
}

