/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.external.libraries;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.n4js.external.libraries.ExternalLibraryFolderUtils;
import org.eclipse.n4js.utils.UtilN4;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class ExternalLibrariesActivator
implements BundleActivator {
    private static final Logger LOGGER = Logger.getLogger(ExternalLibrariesActivator.class);
    private static final String PLUGINS_FOLDER_NAME = "plugins";
    public static final String INCLUDES_BUILT_INS_PRODUCT_PROPERTY = "includesBuiltInLibraries";
    public static final String INCLUDES_BUILT_INS_SYSTEM_PROPERTY = "org.eclipse.n4js.includesBuiltInLibraries";
    public static final String LANG_CATEGORY = "lang";
    public static final String RUNTIME_CATEGORY = "runtime";
    public static final String MANGELHAFT_CATEGORY = "mangelhaft";
    public static final String NPM_CATEGORY = "node_modules";
    public static final List<String> CATEGORY_SHADOWING_ORDER = ImmutableList.builder().add((Object)"lang").add((Object)"runtime").add((Object)"mangelhaft").add((Object)"node_modules").build();
    private static final Function<URL, URL> URL_TO_FILE_URL_FUNC = url -> {
        try {
            return FileLocator.toFileURL((URL)url);
        }
        catch (IOException e) {
            String message = "Error while converting URL to file URL. " + url;
            LOGGER.error((Object)message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
    };
    private static final Function<URL, URI> URL_TO_URI_FUNC = url -> {
        if ("file".equals(url.getProtocol())) {
            return new File(url.getFile()).toURI();
        }
        String message = "Unexpected protocol while trying to convert URL to URI." + url;
        LOGGER.error((Object)message);
        return null;
    };
    private static final Function<File, File> FILE_TO_CANONICAL_FILE = file -> {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            String message = "Error while getting the canonical file. " + file;
            LOGGER.error((Object)message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
    };
    public static final String SHIPPED_CODE_FOLDER_NAME = "shipped-code";
    public static final Collection<String> SHIPPED_ROOTS_FOLDER_NAMES = ImmutableList.builder().add((Object)"lang").add((Object)"runtime").add((Object)"mangelhaft").build();
    public static final Collection<String> EXTERNAL_LIBRARY_FOLDER_NAMES = ImmutableList.builder().addAll(SHIPPED_ROOTS_FOLDER_NAMES).add((Object)"node_modules").build();
    public static final String PLUGIN_ID = "org.eclipse.n4js.external.libraries";
    public static final Map<String, String> EXTERNAL_LIBRARY_NAMES = ImmutableMap.builder().put((Object)"lang", (Object)"N4JS Language").put((Object)"runtime", (Object)"N4JS Runtime").put((Object)"mangelhaft", (Object)"Mangelhaft").put((Object)"node_modules", (Object)"node_modules").build();
    public static final Supplier<BiMap<URI, String>> EXTERNAL_LIBRARIES_SUPPLIER = Suppliers.memoize(() -> ExternalLibrariesActivator.getExternalLibraries());
    public static final Supplier<File> N4_NPM_FOLDER_SUPPLIER = Suppliers.memoize(() -> ExternalLibrariesActivator.getOrCreateNpmFolder());
    private static BundleContext context;

    public static Path getShippedCodeFolderPath() {
        Path n4jsRepoRootPath = UtilN4.findN4jsRepoRootPath();
        return n4jsRepoRootPath.resolve(PLUGINS_FOLDER_NAME).resolve(PLUGIN_ID).resolve(SHIPPED_CODE_FOLDER_NAME);
    }

    public static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        N4_NPM_FOLDER_SUPPLIER.get();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
    }

    public static boolean requiresInfrastructureForLibraryManager() {
        IProduct product;
        if (Platform.isRunning() && (product = Platform.getProduct()) != null && Boolean.parseBoolean(product.getProperty(INCLUDES_BUILT_INS_PRODUCT_PROPERTY))) {
            return !Platform.inDebugMode() && !Platform.inDevelopmentMode() || Boolean.parseBoolean(System.getProperty(INCLUDES_BUILT_INS_SYSTEM_PROPERTY));
        }
        return false;
    }

    public static List<URI> sortByShadowing(Collection<URI> locations) {
        HashMap<String, URI> knownLocations = new HashMap<String, URI>();
        LinkedList<URI> unknownLocations = new LinkedList<URI>();
        for (URI location : locations) {
            String locStr = location.toString();
            locStr = locStr.endsWith("/") ? locStr.substring(0, locStr.length() - 1) : locStr;
            boolean locationFound = false;
            for (String knownLocation : CATEGORY_SHADOWING_ORDER) {
                if (!locStr.endsWith(knownLocation) || knownLocations.containsKey(knownLocation)) continue;
                knownLocations.put(knownLocation, location);
                locationFound = true;
            }
            if (locationFound) continue;
            unknownLocations.add(location);
        }
        LinkedList<URI> sortedLocations = new LinkedList<URI>();
        for (String knownLocation : CATEGORY_SHADOWING_ORDER) {
            URI location = (URI)knownLocations.get(knownLocation);
            if (location == null) continue;
            sortedLocations.add(location);
        }
        sortedLocations.addAll(unknownLocations);
        return sortedLocations;
    }

    public static void log(IStatus status) {
        Bundle bundle;
        if (status != null && Platform.isRunning() && context != null && (bundle = context.getBundle()) != null) {
            Platform.getLog((Bundle)bundle).log(status);
        }
    }

    public static synchronized File getOrCreateNestedFolder(String path) {
        Preconditions.checkState((boolean)Platform.isRunning(), (Object)"Expected running platform.");
        Bundle bundle = context.getBundle();
        Preconditions.checkNotNull((Object)bundle, (Object)"Bundle was null. Does the platform running?");
        File targetPlatform = InternalPlatform.getDefault().getStateLocation(bundle).append(path).toFile();
        if (!targetPlatform.exists()) {
            Preconditions.checkState((boolean)targetPlatform.mkdirs(), (Object)("Error while creating " + targetPlatform + " folder."));
        }
        Preconditions.checkState((boolean)targetPlatform.isDirectory(), (Object)("Expecting director but was a file: " + targetPlatform + "."));
        return targetPlatform;
    }

    private static BiMap<URI, String> getExternalLibraries() {
        Bundle bundle = context.getBundle();
        Preconditions.checkNotNull((Object)bundle, (Object)"Bundle was null. Is the platform running?");
        FluentIterable uriNamePairs = FluentIterable.from(EXTERNAL_LIBRARY_FOLDER_NAMES).transform(name -> bundle.getResource(name)).filter(Predicates.notNull()).transform(URL_TO_FILE_URL_FUNC).transform(URL_TO_URI_FUNC).filter(Predicates.notNull()).transform(uri -> new File((URI)uri)).transform(FILE_TO_CANONICAL_FILE).transform(file -> file.toURI()).transform(uri -> Tuples.pair((Object)uri, (Object)new File((URI)uri).getName()));
        LinkedHashMap uriMappings = Maps.newLinkedHashMap();
        File targetPlatformInstallLocation = (File)N4_NPM_FOLDER_SUPPLIER.get();
        File nodeModulesFolder = new File(targetPlatformInstallLocation, NPM_CATEGORY);
        uriMappings.put(nodeModulesFolder.toURI(), NPM_CATEGORY);
        for (Pair pair : uriNamePairs) {
            uriMappings.put((URI)pair.getFirst(), (String)pair.getSecond());
        }
        return ImmutableBiMap.copyOf((Map)uriMappings);
    }

    private static File getOrCreateNpmFolder() {
        File targetPlatform = ExternalLibrariesActivator.getOrCreateNestedFolder(".n4npm");
        File nodeModulesFolder = new File(targetPlatform, NPM_CATEGORY);
        if (!nodeModulesFolder.exists()) {
            Preconditions.checkState((boolean)nodeModulesFolder.mkdir(), (Object)("Error while creating " + nodeModulesFolder + " folder."));
        }
        Preconditions.checkState((boolean)nodeModulesFolder.isDirectory(), (Object)("Expecting directory but was a file: " + nodeModulesFolder + "."));
        File targetPlatformFile = ExternalLibraryFolderUtils.createTargetPlatformDefinitionFile(targetPlatform);
        Preconditions.checkState((boolean)targetPlatformFile.isFile(), (Object)("Expecting file as the target platform file: " + targetPlatformFile + "."));
        return targetPlatform;
    }
}

