/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.external.libraries;

import com.google.common.base.Preconditions;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Throwables;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteStreams;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringJoiner;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.n4js.external.libraries.ExternalLibrariesActivator;
import org.eclipse.n4js.utils.io.FileDeleter;

public class ShippedCodeAccess {
    public static final Iterable<String> getAllShippedPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        ExternalLibrariesActivator.SHIPPED_ROOTS_FOLDER_NAMES.forEach(root -> {
            boolean bl = paths.add(ShippedCodeAccess.getShippedRuntimeCodePath(root));
        });
        return paths;
    }

    protected static String getShippedRuntimeCodePath(String rootName) {
        try {
            URL resourceUrl = ShippedCodeAccess.getResource(rootName);
            URLConnection connection = resourceUrl.openConnection();
            if (connection instanceof JarURLConnection) {
                return ShippedCodeAccess.recursivelyCopyContent((JarURLConnection)connection, rootName);
            }
            return new File(resourceUrl.toURI()).getCanonicalFile().getAbsolutePath().replace("\\", "\\\\");
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting shipped code path.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String recursivelyCopyContent(JarURLConnection connection, String rootName) throws IOException {
        File tempFolder = ShippedCodeAccess.getTempFolder();
        tempFolder.deleteOnExit();
        File rootFolder = new File(tempFolder, rootName);
        if (rootFolder.exists()) {
            FileDeleter.delete((Path)rootFolder.toPath());
        }
        Preconditions.checkState((boolean)rootFolder.mkdir(), (Object)("Error while creating folder for Node.js environment. " + rootFolder));
        Preconditions.checkState((boolean)rootFolder.isDirectory(), (Object)("Expected directory but got a file: " + rootFolder));
        rootFolder.deleteOnExit();
        Throwable throwable = null;
        Object var5_6 = null;
        try (JarFile jarFile = connection.getJarFile();){
            Enumeration<JarEntry> em = jarFile.entries();
            while (true) {
                File newResource;
                block26: {
                    if (!em.hasMoreElements()) {
                        return rootFolder.getCanonicalFile().getAbsolutePath().replace("\\", "\\\\");
                    }
                    JarEntry entry = em.nextElement();
                    if (!entry.getName().startsWith(rootName)) continue;
                    String fileName = entry.getName();
                    newResource = new File(tempFolder, fileName);
                    if (entry.isDirectory()) {
                        if (!newResource.exists()) {
                            Preconditions.checkState((boolean)newResource.mkdir(), (Object)("Error while creating new folder at: " + newResource));
                        }
                    } else {
                        Preconditions.checkState((boolean)newResource.createNewFile(), (Object)("Error while creating new file at: " + newResource));
                        ByteSink byteSink = Files.asByteSink((File)newResource, (FileWriteMode[])new FileWriteMode[0]);
                        Throwable throwable2 = null;
                        Object var13_16 = null;
                        try {
                            InputStream is = jarFile.getInputStream(entry);
                            try {
                                try (OutputStream outputStream = byteSink.openStream();){
                                    ByteStreams.copy((InputStream)is, (OutputStream)outputStream);
                                }
                                if (is == null) break block26;
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                if (is == null) throw throwable2;
                                is.close();
                                throw throwable2;
                            }
                            is.close();
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                                throw throwable2;
                            }
                            if (throwable2 == throwable4) throw throwable2;
                            throwable2.addSuppressed(throwable4);
                            throw throwable2;
                        }
                    }
                }
                newResource.deleteOnExit();
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            }
            if (throwable == throwable5) throw throwable;
            throwable.addSuppressed(throwable5);
            throw throwable;
        }
    }

    private static File getTempFolder() {
        String tempFolder = StandardSystemProperty.JAVA_IO_TMPDIR.value();
        File file = new File(tempFolder);
        if (!file.exists() || !file.canWrite()) {
            throw new RuntimeException("Cannot access temporary directory under: " + tempFolder);
        }
        return file;
    }

    protected static URL getResource(String resourceName) {
        if (resourceName == null) {
            throw new RuntimeException("Resource name cannot be null.");
        }
        if (resourceName.isEmpty()) {
            throw new RuntimeException("Resource name cannot be empty.");
        }
        String locator = "/" + resourceName;
        URL resourceUrl = ShippedCodeAccess.class.getResource(locator);
        if (resourceUrl == null) {
            throw new RuntimeException("Obtaining resource with locator <" + locator + "> returned null.");
        }
        if (!Platform.isRunning()) {
            return resourceUrl;
        }
        try {
            URL transformedResourceUrl = FileLocator.toFileURL((URL)resourceUrl);
            if (transformedResourceUrl == null) {
                throw new RuntimeException("Transforming resource with url <" + resourceUrl + "> returned null.");
            }
            return transformedResourceUrl;
        }
        catch (Exception originalException) {
            StringJoiner errLog = new StringJoiner("\n");
            errLog.add("Tried to convert resource URL:: " + resourceUrl);
            errLog.add("Original error >>> ");
            errLog.add(Throwables.getStackTraceAsString((Throwable)originalException));
            errLog.add("<<< Original error");
            if (Platform.isRunning()) {
                URL foundResource = FileLocator.find((URL)resourceUrl);
                errLog.add("Finding resource by URL :: " + foundResource);
                if (foundResource != null) {
                    try {
                        errLog.add("Converting resource URL :: " + FileLocator.toFileURL((URL)resourceUrl));
                    }
                    catch (IOException e1) {
                        errLog.add("Resource URL conversion throws :: ");
                        errLog.add(Throwables.getStackTraceAsString((Throwable)e1));
                    }
                }
            } else {
                errLog.add("Platform is not running anymore (probably crashed). Cannot obtain more information.");
            }
            System.err.println(errLog.toString());
            throw new RuntimeException("Error while converting resource.");
        }
    }
}

