package org.eclipse.n4js.json.resource;

import com.google.inject.Inject;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.json.extension.IJSONResourceDescriptionExtension;
import org.eclipse.n4js.json.extension.JSONExtensionRegistry;
import org.eclipse.n4js.utils.resources.IBuildSuppressingResourceDescriptionManager;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionManager;

/**
 * Resource description manager for JSON files. Delegates to registered JSON extensions.
 */
@SuppressWarnings("all")
public class JSONResourceDescriptionManager extends DefaultResourceDescriptionManager implements IBuildSuppressingResourceDescriptionManager {
  @Inject
  private JSONExtensionRegistry extensionRegistry;
  
  /**
   * By default, JSON files won't be built by the incremental builder, but extensions can decide to build certain JSON files.
   */
  @Override
  public boolean isToBeBuilt(final URI uri, final Resource resource) {
    Collection<IJSONResourceDescriptionExtension> _resourceDescriptionExtensions = this.extensionRegistry.getResourceDescriptionExtensions();
    for (final IJSONResourceDescriptionExtension ext : _resourceDescriptionExtensions) {
      boolean _isToBeBuilt = ext.isToBeBuilt(uri, resource);
      if (_isToBeBuilt) {
        return true;
      }
    }
    return false;
  }
  
  /**
   * Delegates to registered resource description extensions.
   */
  @Override
  public boolean isAffected(final Collection<IResourceDescription.Delta> deltas, final IResourceDescription candidate, final IResourceDescriptions context) {
    Collection<IJSONResourceDescriptionExtension> _resourceDescriptionExtensions = this.extensionRegistry.getResourceDescriptionExtensions();
    for (final IJSONResourceDescriptionExtension ext : _resourceDescriptionExtensions) {
      boolean _isAffected = ext.isAffected(deltas, candidate, context);
      if (_isAffected) {
        return true;
      }
    }
    return false;
  }
}
