/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.antlr.syntaxcoloring;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.antlr.syntaxcoloring.N4JSAntlrHighlightingGrammarGenerator;
import org.eclipse.n4js.antlr.syntaxcoloring.N4JSHighlightingGrammarNaming;
import org.eclipse.xtend.lib.annotations.Delegate;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.RuntimeIOException;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xtext.generator.model.IXtextGeneratorFileSystemAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;
import org.eclipse.xtext.xtext.generator.parser.antlr.AbstractAntlrGeneratorFragment2;
import org.eclipse.xtext.xtext.generator.parser.antlr.AntlrGrammar;
import org.eclipse.xtext.xtext.generator.parser.antlr.GrammarNaming;
import org.eclipse.xtext.xtext.generator.parser.antlr.XtextAntlrGeneratorFragment2;

/**
 * Custom variant of {@link XtextAntlrGeneratorFragment2} generating the highlighting grammar & parser
 *  without a dedicated lexer, reuses the production lexer.
 */
@SuppressWarnings("all")
public class N4JSHighlightingParserGeneratorFragment2 extends XtextAntlrGeneratorFragment2 {
  /**
   * TODO IDE-2406:Can be removed once https://github.com/eclipse/xtext-core/issues/158
   *  is resolved and the solution is leveraged in N4JSAntlrHighlightingGrammarGenerator.
   */
  @FinalFieldsConstructor
  public static class GuardedXtextGeneratorFileSystemAccess implements IXtextGeneratorFileSystemAccess {
    @Delegate
    private final IXtextGeneratorFileSystemAccess delegate;
    
    public GuardedXtextGeneratorFileSystemAccess(final IXtextGeneratorFileSystemAccess delegate) {
      super();
      this.delegate = delegate;
    }
    
    public String getPath() {
      return this.delegate.getPath();
    }
    
    public boolean isOverwrite() {
      return this.delegate.isOverwrite();
    }
    
    public boolean isFile(final String arg0, final String arg1) throws RuntimeIOException {
      return this.delegate.isFile(arg0, arg1);
    }
    
    public boolean isFile(final String arg0) throws RuntimeIOException {
      return this.delegate.isFile(arg0);
    }
    
    public void generateFile(final String arg0, final CharSequence arg1) {
      this.delegate.generateFile(arg0, arg1);
    }
    
    public void generateFile(final String arg0, final String arg1, final CharSequence arg2) {
      this.delegate.generateFile(arg0, arg1, arg2);
    }
    
    public void deleteFile(final String arg0) {
      this.delegate.deleteFile(arg0);
    }
    
    public void deleteFile(final String arg0, final String arg1) {
      this.delegate.deleteFile(arg0, arg1);
    }
    
    public URI getURI(final String arg0, final String arg1) {
      return this.delegate.getURI(arg0, arg1);
    }
    
    public URI getURI(final String arg0) {
      return this.delegate.getURI(arg0);
    }
    
    public void generateFile(final String arg0, final String arg1, final InputStream arg2) throws RuntimeIOException {
      this.delegate.generateFile(arg0, arg1, arg2);
    }
    
    public void generateFile(final String arg0, final InputStream arg1) throws RuntimeIOException {
      this.delegate.generateFile(arg0, arg1);
    }
    
    public InputStream readBinaryFile(final String arg0, final String arg1) throws RuntimeIOException {
      return this.delegate.readBinaryFile(arg0, arg1);
    }
    
    public InputStream readBinaryFile(final String arg0) throws RuntimeIOException {
      return this.delegate.readBinaryFile(arg0);
    }
    
    public CharSequence readTextFile(final String arg0, final String arg1) throws RuntimeIOException {
      return this.delegate.readTextFile(arg0, arg1);
    }
    
    public CharSequence readTextFile(final String arg0) throws RuntimeIOException {
      return this.delegate.readTextFile(arg0);
    }
    
    public void initialize(final Injector arg0) {
      this.delegate.initialize(arg0);
    }
  }
  
  @Inject
  private GrammarNaming productionNaming;
  
  @Inject
  @Extension
  private N4JSHighlightingGrammarNaming highlightingNaming;
  
  @Inject
  private N4JSAntlrHighlightingGrammarGenerator highlightingGenerator;
  
  @Override
  protected void doGenerate() {
    this.generateHighlightingGrammar();
  }
  
  protected void generateHighlightingGrammar() {
    final IXtextGeneratorFileSystemAccess fsa = this.getProjectConfig().getEclipsePlugin().getSrcGen();
    this.highlightingGenerator.generate(this.getGrammar(), this.getOptions(), new N4JSHighlightingParserGeneratorFragment2.GuardedXtextGeneratorFileSystemAccess(fsa) {
      /**
       * Via this customization the generation of an additional lexer grammar is suppressed,
       *  since the production lexer is re-used.
       * TODO IDE-2406: Can be removed once https://github.com/eclipse/xtext-core/issues/158
       *  is resolved and the solution is leveraged in N4JSAntlrHighlightingGrammarGenerator.
       */
      @Override
      public void generateFile(final String fileName, final CharSequence contents) {
        if ((contents != null)) {
          super.generateFile(fileName, contents);
        }
      }
    });
    this.runAntlr(this.highlightingNaming.getParserGrammar(this.getGrammar()), null, fsa);
    this.simplifyUnorderedGroupPredicatesIfRequired(this.getGrammar(), fsa, this.highlightingNaming.getInternalParserClass(this.getGrammar()));
    this.splitParserAndLexerIfEnabled(fsa, this.highlightingNaming.getInternalParserClass(this.getGrammar()), null);
    this.normalizeTokens(fsa, this.highlightingNaming.getParserGrammar(this.getGrammar()).getTokensFileName());
    this.suppressWarnings(fsa, this.highlightingNaming.getInternalParserClass(this.getGrammar()));
    this.normalizeLineDelimiters(fsa, this.highlightingNaming.getInternalParserClass(this.getGrammar()));
  }
  
  @Override
  protected void runAntlr(final AntlrGrammar parserGrammar, final AntlrGrammar lexerGrammar, final IXtextGeneratorFileSystemAccess fsa) {
    final IXtextGeneratorFileSystemAccess src_gen = this.getProjectConfig().getRuntime().getSrcGen();
    final IXtextGeneratorFileSystemAccess src_gen_ui = this.getProjectConfig().getEclipsePlugin().getSrcGen();
    final AntlrGrammar theLexerGrammar = this.productionNaming.getLexerGrammar(this.getGrammar());
    final String encoding = this.getCodeConfig().getEncoding();
    StringConcatenation _builder = new StringConcatenation();
    String _path = src_gen.getPath();
    _builder.append(_path);
    _builder.append("/");
    String _grammarFileName = theLexerGrammar.getGrammarFileName();
    _builder.append(_grammarFileName);
    final String lexerGrammarFile = _builder.toString();
    final String lexerOutputDir = lexerGrammarFile.substring(0, lexerGrammarFile.lastIndexOf("/"));
    StringConcatenation _builder_1 = new StringConcatenation();
    String _path_1 = src_gen_ui.getPath();
    _builder_1.append(_path_1);
    _builder_1.append("/");
    String _grammarFileName_1 = parserGrammar.getGrammarFileName();
    _builder_1.append(_grammarFileName_1);
    final String parserGrammarFile = _builder_1.toString();
    final ArrayList<String> parserAntlrParams = CollectionLiterals.<String>newArrayList(this.getAntlrParams());
    parserAntlrParams.add("-fo");
    String _substring = parserGrammarFile.substring(0, parserGrammarFile.lastIndexOf("/"));
    parserAntlrParams.add(_substring);
    parserAntlrParams.add("-lib");
    parserAntlrParams.add(lexerOutputDir);
    this.getAntlrTool().runWithEncodingAndParams(parserGrammarFile, encoding, ((String[])Conversions.unwrapArray(parserAntlrParams, String.class)));
  }
  
  @Override
  protected void splitLexerClassFile(final IXtextGeneratorFileSystemAccess fsa, final TypeReference lexer) {
  }
  
  /**
   * Needed to copy this method from the super class
   * {@link AbstractAntlrGeneratorFragment2 AbstractAntlrGeneratorFragment2}
   * in order to deactivate the lexer specific parts.
   */
  @Override
  protected void improveCodeQuality(final IXtextGeneratorFileSystemAccess fsa, final TypeReference lexer, final TypeReference parser) {
    String parserContent = fsa.readTextFile(parser.getJavaPath()).toString();
    parserContent = this.getCodeQualityHelper().stripUnnecessaryComments(parserContent, this.getOptions());
    parserContent = this.getCodeQualityHelper().removeDuplicateBitsets(parserContent, this.getOptions());
    parserContent = this.getCodeQualityHelper().removeDuplicateDFAs(parserContent, this.getOptions());
    fsa.generateFile(parser.getJavaPath(), parserContent);
  }
}
