/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.formatting2;

import org.eclipse.n4js.formatting2.InsertSemiBase;
import org.eclipse.xtext.formatting2.ITextReplacer;
import org.eclipse.xtext.formatting2.ITextReplacerContext;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;

@SuppressWarnings("all")
public class InsertSemiFollowedByTextReplacer implements InsertSemiBase {
  private final InsertSemiBase insertSemi;
  
  private final ITextReplacer textReplacer;
  
  private final ITextSegment region;
  
  public InsertSemiFollowedByTextReplacer(final InsertSemiBase insertSemi, final ITextReplacer textReplacer) {
    this.insertSemi = insertSemi;
    this.textReplacer = textReplacer;
    this.region = insertSemi.getRegion().merge(textReplacer.getRegion());
  }
  
  @Override
  public ITextReplacerContext createReplacements(final ITextReplacerContext context) {
    ITextReplacerContext replContext = this.insertSemi.createReplacements(context).withReplacer(this.textReplacer);
    return this.textReplacer.createReplacements(replContext);
  }
  
  @Override
  public ITextSegment getRegion() {
    return this.region;
  }
}
