/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.n4idl.scoping;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.scoping.N4JSScopeProvider;
import org.eclipse.n4js.scoping.utils.LocallyKnownTypesScopingHelper;
import org.eclipse.n4js.ts.typeRefs.TypeRefsPackage;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.xtext.scoping.IScope;

/**
 * A provider for version scopes.
 */
@SuppressWarnings("all")
public class VersionScopeProvider {
  @Inject
  private N4JSScopeProvider scopeProvider;
  
  @Inject
  private LocallyKnownTypesScopingHelper locallyKnownTypesScopingHelper;
  
  /**
   * Returns a scope containing all versions of the given type.
   */
  public IScope getVersionScope(final Type type) {
    TModule _containingModule = type.getContainingModule();
    boolean _tripleNotEquals = (null != _containingModule);
    if (_tripleNotEquals) {
      EObject _astElement = type.getContainingModule().getAstElement();
      final Script script = ((Script) _astElement);
      return this.locallyKnownTypesScopingHelper.scopeWithLocallyDeclaredTypes(script, IScope.NULLSCOPE);
    } else {
      return this.scopeProvider.getN4JSScope(type, 
        TypeRefsPackage.Literals.PARAMETERIZED_TYPE_REF__DECLARED_TYPE);
    }
  }
}
