/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.organize.imports;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.ImportSpecifier;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.NamespaceImportSpecifier;
import org.eclipse.n4js.organize.imports.ImportProvidedElement;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

/**
 * Register holding results of analyzing {@link ImportDeclaration}s
 * and contained {@link ImportSpecifier}s.
 */
@SuppressWarnings("all")
public class RecordingImportState {
  public List<Pair<ImportDeclaration, List<ImportDeclaration>>> duplicatedImportDeclarations = CollectionLiterals.<Pair<ImportDeclaration, List<ImportDeclaration>>>newArrayList();
  
  public List<ImportSpecifier> unusedImports = CollectionLiterals.<ImportSpecifier>newArrayList();
  
  public List<ImportSpecifier> brokenImports = CollectionLiterals.<ImportSpecifier>newArrayList();
  
  /**
   * TODO refactor nested collections into specialized types
   */
  public List<Pair<Pair<String, TModule>, List<ImportProvidedElement>>> duplicateImportsOfSameElement = CollectionLiterals.<Pair<Pair<String, TModule>, List<ImportProvidedElement>>>newArrayList();
  
  public List<Pair<String, List<ImportProvidedElement>>> localNameCollision = CollectionLiterals.<Pair<String, List<ImportProvidedElement>>>newArrayList();
  
  public List<ImportProvidedElement> allUsedTypeNameToSpecifierTuples = CollectionLiterals.<ImportProvidedElement>newArrayList();
  
  public boolean registerDuplicatesOfImportDeclaration(final ImportDeclaration declaration, final List<ImportDeclaration> duplicates) {
    Pair<ImportDeclaration, List<ImportDeclaration>> _mappedTo = Pair.<ImportDeclaration, List<ImportDeclaration>>of(declaration, duplicates);
    return this.duplicatedImportDeclarations.add(_mappedTo);
  }
  
  public boolean isDuplicatingImportDeclaration(final ImportDeclaration importDeclaration) {
    final Function1<Pair<ImportDeclaration, List<ImportDeclaration>>, Boolean> _function = (Pair<ImportDeclaration, List<ImportDeclaration>> dupePair) -> {
      return Boolean.valueOf(((dupePair.getKey().getModule() == importDeclaration.getModule()) && 
        dupePair.getValue().contains(importDeclaration)));
    };
    return IterableExtensions.<Pair<ImportDeclaration, List<ImportDeclaration>>>exists(this.duplicatedImportDeclarations, _function);
  }
  
  public boolean registerUnusedImport(final ImportSpecifier specifier) {
    return this.unusedImports.add(specifier);
  }
  
  public boolean registerBrokenImport(final ImportSpecifier specifier) {
    return this.brokenImports.add(specifier);
  }
  
  /**
   * Removes any information stored in the register.
   */
  public List<ImportProvidedElement> cleanup() {
    List<ImportProvidedElement> _xblockexpression = null;
    {
      final Consumer<List<?>> _function = (List<?> it) -> {
        it.clear();
      };
      Collections.<List<?>>unmodifiableList(CollectionLiterals.<List<?>>newArrayList(this.unusedImports, this.brokenImports, this.allUsedTypeNameToSpecifierTuples)).forEach(_function);
      this.localNameCollision.clear();
      this.duplicatedImportDeclarations.clear();
      this.duplicateImportsOfSameElement.clear();
      _xblockexpression = this.allUsedTypeNameToSpecifierTuples = null;
    }
    return _xblockexpression;
  }
  
  public List<ImportProvidedElement> registerAllUsedTypeNameToSpecifierTuples(final List<ImportProvidedElement> pairs) {
    return this.allUsedTypeNameToSpecifierTuples = pairs;
  }
  
  public void removeDuplicatedImportsOfSameelement(final List<ImportDeclaration> declarations, final Adapter nodelessMarker) {
    final Consumer<Pair<Pair<String, TModule>, List<ImportProvidedElement>>> _function = (Pair<Pair<String, TModule>, List<ImportProvidedElement>> e) -> {
      final Consumer<ImportProvidedElement> _function_1 = (ImportProvidedElement e2) -> {
        this.removeFrom(CollectionLiterals.<ImportSpecifier>newArrayList(e2.getImportSpecifier()), declarations, nodelessMarker);
      };
      e.getValue().forEach(_function_1);
    };
    this.duplicateImportsOfSameElement.forEach(_function);
  }
  
  public void removeLocalNameCollisions(final List<ImportDeclaration> declarations, final Adapter nodelessMarker) {
    final Consumer<Pair<String, List<ImportProvidedElement>>> _function = (Pair<String, List<ImportProvidedElement>> e) -> {
      final Consumer<ImportProvidedElement> _function_1 = (ImportProvidedElement e2) -> {
        this.removeFrom(CollectionLiterals.<ImportSpecifier>newArrayList(e2.getImportSpecifier()), declarations, nodelessMarker);
      };
      e.getValue().forEach(_function_1);
    };
    this.localNameCollision.forEach(_function);
    return;
  }
  
  public void removeDuplicatedImportDeclarations(final List<ImportDeclaration> declarations) {
    final Consumer<Pair<ImportDeclaration, List<ImportDeclaration>>> _function = (Pair<ImportDeclaration, List<ImportDeclaration>> decl2dupes) -> {
      declarations.removeAll(decl2dupes.getValue());
    };
    this.duplicatedImportDeclarations.forEach(_function);
  }
  
  public void removeUnusedImports(final List<ImportDeclaration> declarations, final Adapter nodelessMarker) {
    this.removeFrom(this.unusedImports, declarations, nodelessMarker);
  }
  
  public void removeBrokenImports(final List<ImportDeclaration> declarations, final Adapter nodelessMarker) {
    this.removeFrom(this.brokenImports, declarations, nodelessMarker);
  }
  
  private void removeFrom(final List<ImportSpecifier> tobeRemoved, final List<ImportDeclaration> declarations, final Adapter nodelessMarker) {
    final Consumer<ImportSpecifier> _function = (ImportSpecifier it) -> {
      boolean _matched = false;
      if (it instanceof NamespaceImportSpecifier) {
        _matched=true;
        declarations.remove(((NamespaceImportSpecifier)it).eContainer());
      }
      if (!_matched) {
        if (it instanceof NamedImportSpecifier) {
          _matched=true;
          EObject _eContainer = ((NamedImportSpecifier)it).eContainer();
          final ImportDeclaration imp = ((ImportDeclaration) _eContainer);
          if ((imp != null)) {
            EList<ImportSpecifier> _importSpecifiers = imp.getImportSpecifiers();
            boolean _tripleNotEquals = (_importSpecifiers != null);
            if (_tripleNotEquals) {
              imp.getImportSpecifiers().remove(it);
              imp.eAdapters().add(nodelessMarker);
            }
            if (((imp.getImportSpecifiers() == null) || imp.getImportSpecifiers().isEmpty())) {
              declarations.remove(imp);
            }
          }
        }
      }
    };
    tobeRemoved.forEach(_function);
  }
  
  /**
   * Returns set of names, for which there are broken import specifiers. Happens after broken
   * imports are removed, which makes name (usually IdRef/TypeRef) refer to ImportSpecifier, which
   * is being removed from document. Providing list of broken names, allows organize imports to fix those.
   */
  public Set<String> calcRemovedImportedNames() {
    HashSet<String> ret = CollectionLiterals.<String>newHashSet();
    for (final ImportProvidedElement e : this.allUsedTypeNameToSpecifierTuples) {
      if ((e.isUsed() && (e.getImportSpecifier().eContainer() == null))) {
        ret.add(e.getLocalName());
      }
    }
    return ret;
  }
  
  public boolean registerDuplicateImportsOfSameElement(final String name, final TModule module, final List<ImportProvidedElement> elements) {
    Pair<String, TModule> _mappedTo = Pair.<String, TModule>of(name, module);
    Pair<Pair<String, TModule>, List<ImportProvidedElement>> _mappedTo_1 = Pair.<Pair<String, TModule>, List<ImportProvidedElement>>of(_mappedTo, elements);
    return this.duplicateImportsOfSameElement.add(_mappedTo_1);
  }
  
  public boolean registerLocalNameCollision(final String string, final List<ImportProvidedElement> elements) {
    boolean _xblockexpression = false;
    {
      final Function1<Pair<String, List<ImportProvidedElement>>, Boolean> _function = (Pair<String, List<ImportProvidedElement>> it) -> {
        String _key = it.getKey();
        return Boolean.valueOf(Objects.equal(_key, string));
      };
      final Pair<String, List<ImportProvidedElement>> key = IterableExtensions.<Pair<String, List<ImportProvidedElement>>>findFirst(this.localNameCollision, _function);
      boolean _xifexpression = false;
      if ((key != null)) {
        _xifexpression = key.getValue().addAll(elements);
      } else {
        List<ImportProvidedElement> _list = IterableExtensions.<ImportProvidedElement>toList(elements);
        Pair<String, List<ImportProvidedElement>> _mappedTo = Pair.<String, List<ImportProvidedElement>>of(string, _list);
        _xifexpression = this.localNameCollision.add(_mappedTo);
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
}
