/**
 * Copyright (c) 2017 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.scoping.imports;

import java.util.Collections;
import java.util.HashMap;
import org.eclipse.n4js.scoping.imports.ImportedElementsMap;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

/**
 * HashMap-based implementation of {@link ImportedElementsMap}.
 * 
 * This map can only hold a single {@link IEObjectDescription} per qualified name.
 */
@SuppressWarnings("all")
public class SingleImportedElementsMap implements ImportedElementsMap {
  private HashMap<QualifiedName, IEObjectDescription> elementsMap;
  
  public SingleImportedElementsMap() {
    this.elementsMap = CollectionLiterals.<QualifiedName, IEObjectDescription>newHashMap();
  }
  
  @Override
  public boolean containsElement(final QualifiedName name) {
    return this.elementsMap.containsKey(name);
  }
  
  @Override
  public Iterable<IEObjectDescription> getElements(final QualifiedName name) {
    final IEObjectDescription result = this.elementsMap.get(name);
    if ((null != result)) {
      return Collections.<IEObjectDescription>unmodifiableList(CollectionLiterals.<IEObjectDescription>newArrayList(result));
    } else {
      return CollectionLiterals.<IEObjectDescription>emptyList();
    }
  }
  
  @Override
  public void put(final QualifiedName name, final IEObjectDescription element) {
    this.elementsMap.put(name, element);
  }
  
  @Override
  public Iterable<IEObjectDescription> values() {
    return this.elementsMap.values();
  }
}
