/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.typesbuilder;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.ExportedVariableDeclaration;
import org.eclipse.n4js.n4JS.ExportedVariableStatement;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.NewExpression;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.VariableStatement;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TVariable;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesbuilder.N4JSTypesBuilderHelper;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.Functions.Function2;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
class N4JSVariableStatementTypesBuilder {
  @Inject
  @Extension
  private N4JSTypesBuilderHelper _n4JSTypesBuilderHelper;
  
  int relinkVariableTypes(final VariableStatement n4VariableStatement, final TModule target, final boolean preLinkingPhase, final int start) {
    final Function2<Integer, ExportedVariableDeclaration, Integer> _function = (Integer idx, ExportedVariableDeclaration decl) -> {
      boolean _relinkVariableType = this.relinkVariableType(decl, target, (idx).intValue());
      if (_relinkVariableType) {
        return Integer.valueOf(((idx).intValue() + 1));
      }
      return idx;
    };
    return (int) IterableExtensions.<ExportedVariableDeclaration, Integer>fold(Iterables.<ExportedVariableDeclaration>filter(n4VariableStatement.getVarDecl(), ExportedVariableDeclaration.class), Integer.valueOf(start), _function);
  }
  
  private boolean relinkVariableType(final ExportedVariableDeclaration n4VariableDeclaration, final TModule target, final int idx) {
    String _name = n4VariableDeclaration.getName();
    boolean _tripleEquals = (_name == null);
    if (_tripleEquals) {
      return false;
    }
    final TVariable variable = target.getVariables().get(idx);
    this._n4JSTypesBuilderHelper.ensureEqualName(n4VariableDeclaration, variable);
    variable.setAstElement(n4VariableDeclaration);
    n4VariableDeclaration.setDefinedVariable(variable);
    return true;
  }
  
  void createVariableTypes(final VariableStatement n4VariableStatement, final TModule target, final boolean preLinkingPhase) {
    final Iterable<TVariable> variables = this.createVariables(n4VariableStatement, preLinkingPhase);
    EList<TVariable> _variables = target.getVariables();
    Iterables.<TVariable>addAll(_variables, variables);
  }
  
  private Iterable<TVariable> createVariables(final VariableStatement n4VariableStatement, final boolean preLinkingPhase) {
    final Function1<ExportedVariableDeclaration, TVariable> _function = (ExportedVariableDeclaration it) -> {
      return this.createVariable(it, n4VariableStatement, preLinkingPhase);
    };
    return IterableExtensions.<TVariable>filterNull(IterableExtensions.<ExportedVariableDeclaration, TVariable>map(Iterables.<ExportedVariableDeclaration>filter(n4VariableStatement.getVarDecl(), ExportedVariableDeclaration.class), _function));
  }
  
  private TVariable createVariable(final ExportedVariableDeclaration n4VariableDeclaration, final VariableStatement n4VariableStatement, final boolean preLinkingPhase) {
    String _name = n4VariableDeclaration.getName();
    boolean _tripleEquals = (_name == null);
    if (_tripleEquals) {
      return null;
    }
    final TVariable variable = TypesFactory.eINSTANCE.createTVariable();
    variable.setName(n4VariableDeclaration.getName());
    variable.setConst(n4VariableDeclaration.isConst());
    Expression _expression = n4VariableDeclaration.getExpression();
    variable.setObjectLiteral((_expression instanceof ObjectLiteral));
    Expression _expression_1 = n4VariableDeclaration.getExpression();
    variable.setNewExpression((_expression_1 instanceof NewExpression));
    if ((n4VariableStatement instanceof ExportedVariableStatement)) {
      String _elvis = null;
      String _exportedName = ((ExportedVariableStatement)n4VariableStatement).getExportedName();
      if (_exportedName != null) {
        _elvis = _exportedName;
      } else {
        String _name_1 = n4VariableDeclaration.getName();
        _elvis = _name_1;
      }
      variable.setExportedName(_elvis);
      this._n4JSTypesBuilderHelper.<ExportedVariableStatement>setTypeAccessModifier(variable, ((ExportedVariableStatement)n4VariableStatement));
    } else {
      variable.setExportedName(null);
    }
    this._n4JSTypesBuilderHelper.copyAnnotations(variable, n4VariableDeclaration, preLinkingPhase);
    variable.setDeclaredProvidedByRuntime(AnnotationDefinition.PROVIDED_BY_RUNTIME.hasAnnotation(n4VariableDeclaration));
    this.setVariableType(variable, n4VariableDeclaration, preLinkingPhase);
    variable.setAstElement(n4VariableDeclaration);
    n4VariableDeclaration.setDefinedVariable(variable);
    return variable;
  }
  
  private void setVariableType(final TVariable variable, final ExportedVariableDeclaration n4VariableDeclaration, final boolean preLinkingPhase) {
    TypeRef _declaredTypeRef = n4VariableDeclaration.getDeclaredTypeRef();
    boolean _tripleNotEquals = (_declaredTypeRef != null);
    if (_tripleNotEquals) {
      if ((!preLinkingPhase)) {
        variable.setTypeRef(TypeUtils.<TypeRef>copyWithProxies(n4VariableDeclaration.getDeclaredTypeRef()));
      }
    } else {
      variable.setTypeRef(TypeUtils.createDeferredTypeRef());
    }
  }
}
