/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.utils;

import java.util.Comparator;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TSetter;

@SuppressWarnings("all")
public class MembersByNameTypeAndAccessComparator implements Comparator<TMember> {
  private final boolean ignoreTypes;
  
  public MembersByNameTypeAndAccessComparator(final boolean ignoreTypes) {
    this.ignoreTypes = ignoreTypes;
  }
  
  /**
   * @return a negative integer, zero, or a positive integer as the
   *         first argument is less than, equal to, or greater than the
   *         second.
   */
  @Override
  public int compare(final TMember m1, final TMember m2) {
    if (((m1 == null) || (m1.getName() == null))) {
      return 1;
    }
    if (((m2 == null) || (m2.getName() == null))) {
      return (-1);
    }
    int c = m1.getName().compareTo(m2.getName());
    if ((c == 0)) {
      int _xifexpression = (int) 0;
      if ((!this.ignoreTypes)) {
        _xifexpression = this.compareMemberType(m1, m2);
      } else {
        _xifexpression = c;
      }
      c = _xifexpression;
      if ((c == 0)) {
        this.compareAccessModifier(m1.getMemberAccessModifier(), m2.getMemberAccessModifier());
      }
    }
    return c;
  }
  
  private int compareMemberType(final TMember m1, final TMember m2) {
    return Integer.compare(this.getMemberTypeOrdinal(m1), this.getMemberTypeOrdinal(m2));
  }
  
  private int getMemberTypeOrdinal(final TMember m) {
    int _switchResult = (int) 0;
    boolean _matched = false;
    if (m instanceof TField) {
      _matched=true;
      _switchResult = 1;
    }
    if (!_matched) {
      if (m instanceof TGetter) {
        _matched=true;
        _switchResult = 2;
      }
    }
    if (!_matched) {
      if (m instanceof TSetter) {
        _matched=true;
        _switchResult = 3;
      }
    }
    if (!_matched) {
      if (m instanceof TMethod) {
        _matched=true;
        _switchResult = 4;
      }
    }
    if (!_matched) {
      String _name = m.eClass().getName();
      String _plus = ("unsupported subclass of TMember: " + _name);
      throw new IllegalArgumentException(_plus);
    }
    return _switchResult;
  }
  
  private int compareAccessModifier(final MemberAccessModifier m1, final MemberAccessModifier m2) {
    int _xifexpression = (int) 0;
    int _ordinal = m1.ordinal();
    int _ordinal_1 = m2.ordinal();
    boolean _greaterEqualsThan = (_ordinal >= _ordinal_1);
    if (_greaterEqualsThan) {
      _xifexpression = 0;
    } else {
      _xifexpression = (-1);
    }
    return _xifexpression;
  }
}
