/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.tests.codegen;

import org.eclipse.n4js.tests.codegen.Member;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

/**
 * Generates code for a getter method of a {@link Classifier}.
 */
@SuppressWarnings("all")
public class Getter extends Member<Getter> {
  private String fieldType;
  
  private String defaultValue;
  
  /**
   * Creates a new getter with the given parameters.
   * 
   * @param name the getter's name
   */
  public Getter(final String name) {
    super(name);
  }
  
  /**
   * Sets the field type.
   * 
   * @param fieldType the field type
   */
  public Getter setFieldType(final String fieldType) {
    this.fieldType = fieldType;
    return this;
  }
  
  /**
   * Sets the default value or expression.
   * 
   * @param defaultValue the default value
   */
  public Getter setDefaultValue(final String defaultValue) {
    this.defaultValue = defaultValue;
    return this;
  }
  
  @java.lang.Override
  protected CharSequence generateMember() {
    StringConcatenation _builder = new StringConcatenation();
    String _generateAbstract = this.generateAbstract();
    _builder.append(_generateAbstract);
    _builder.append("get ");
    _builder.append(this.name);
    _builder.append("()");
    {
      boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(this.fieldType);
      boolean _not = (!_isNullOrEmpty);
      if (_not) {
        _builder.append(": ");
        _builder.append(this.fieldType);
      }
    }
    {
      boolean _isAbstract = this.isAbstract();
      if (_isAbstract) {
        _builder.append(";");
      } else {
        _builder.append(" { return ");
        {
          boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty(this.defaultValue);
          if (_isNullOrEmpty_1) {
            _builder.append("null");
          } else {
            _builder.append("defaultValue");
          }
        }
        _builder.append("; }");
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }
}
