/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.tests.codegen;

import org.eclipse.n4js.tests.codegen.Member;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

/**
 * Generates code for a setter method of a {@link Classifier}.
 */
@SuppressWarnings("all")
public class Setter extends Member<Setter> {
  protected String fieldType;
  
  /**
   * Creates a new setter with the given parameters.
   * 
   * @param name the setter's name
   */
  public Setter(final String name) {
    super(name);
  }
  
  /**
   * Sets the field type of this setter.
   * 
   * @param fieldType the field type
   */
  public Setter setFieldType(final String fieldType) {
    this.fieldType = fieldType;
    return this;
  }
  
  @java.lang.Override
  protected CharSequence generateMember() {
    StringConcatenation _builder = new StringConcatenation();
    String _generateAbstract = this.generateAbstract();
    _builder.append(_generateAbstract);
    _builder.append("set ");
    _builder.append(this.name);
    _builder.append("(value");
    {
      boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(this.fieldType);
      boolean _not = (!_isNullOrEmpty);
      if (_not) {
        _builder.append(": ");
        _builder.append(this.fieldType);
      }
    }
    _builder.append(")");
    {
      boolean _isAbstract = this.isAbstract();
      if (_isAbstract) {
        _builder.append(";");
      } else {
        _builder.append(" {}");
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }
}
