/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.tests.parser;

import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.n4js.tests.parser.AbstractParserTest;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRefStructural;
import org.eclipse.n4js.ts.typeRefs.ThisTypeRefStructural;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Pair;
import org.junit.Assert;

/**
 * Base class for structural typing test, providing some assert methods.
 */
@SuppressWarnings("all")
public abstract class AbstractStructuralTypingTest extends AbstractParserTest {
  public void assertField(final String expectedType, final String expectedName, final TMember member) {
    final TField field = this.<TField>assertType(TField.class, member);
    TypeRef _typeRef = field.getTypeRef();
    String _typeRefAsString = null;
    if (_typeRef!=null) {
      _typeRefAsString=_typeRef.getTypeRefAsString();
    }
    Assert.assertEquals(expectedType, _typeRefAsString);
    Assert.assertEquals(expectedName, field.getName());
  }
  
  public void assertMethod(final String expectedType, final List<String> expectedFPars, final String expectedName, final TMember member) {
    final TMethod method = this.<TMethod>assertType(TMethod.class, member);
    TypeRef _returnTypeRef = method.getReturnTypeRef();
    String _typeRefAsString = null;
    if (_returnTypeRef!=null) {
      _typeRefAsString=_returnTypeRef.getTypeRefAsString();
    }
    Assert.assertEquals(expectedType, _typeRefAsString);
    Assert.assertEquals(expectedName, method.getName());
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _hasElements = false;
      for(final String p : expectedFPars) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(",", "");
        }
        _builder.append(p);
      }
    }
    String expected = _builder.toString();
    StringConcatenation _builder_1 = new StringConcatenation();
    {
      EList<TFormalParameter> _fpars = method.getFpars();
      boolean _hasElements_1 = false;
      for(final TFormalParameter m : _fpars) {
        if (!_hasElements_1) {
          _hasElements_1 = true;
        } else {
          _builder_1.appendImmediate(",", "");
        }
        String _typeRefAsString_1 = m.getTypeRef().getTypeRefAsString();
        _builder_1.append(_typeRefAsString_1);
      }
    }
    String actual = _builder_1.toString();
    Assert.assertEquals(expected, actual);
  }
  
  public void assertGetter(final String expectedType, final String expectedName, final TMember member) {
    final TGetter getter = this.<TGetter>assertType(TGetter.class, member);
    TypeRef _declaredTypeRef = getter.getDeclaredTypeRef();
    String _typeRefAsString = null;
    if (_declaredTypeRef!=null) {
      _typeRefAsString=_declaredTypeRef.getTypeRefAsString();
    }
    Assert.assertEquals(expectedType, _typeRefAsString);
    Assert.assertEquals(expectedName, getter.getName());
  }
  
  public void assertSetter(final String expectedType, final String expectedName, final TMember member) {
    final TSetter setter = this.<TSetter>assertType(TSetter.class, member);
    TypeRef _declaredTypeRef = setter.getDeclaredTypeRef();
    String _typeRefAsString = null;
    if (_declaredTypeRef!=null) {
      _typeRefAsString=_declaredTypeRef.getTypeRefAsString();
    }
    Assert.assertEquals(expectedType, _typeRefAsString);
    Assert.assertEquals(expectedName, setter.getName());
  }
  
  public void assertAdditionalFieldsPTR(final TypingStrategy expectedStrategy, final List<Pair<String, String>> pairs, final TypeRef ref) {
    this.<ParameterizedTypeRefStructural>assertType(ParameterizedTypeRefStructural.class, ref);
    final ParameterizedTypeRefStructural ptrs = ((ParameterizedTypeRefStructural) ref);
    String _name = expectedStrategy.getName();
    String _plus = ("Expected " + _name);
    String _plus_1 = (_plus + " but was ");
    TypingStrategy _typingStrategy = ptrs.getTypingStrategy();
    String _name_1 = null;
    if (_typingStrategy!=null) {
      _name_1=_typingStrategy.getName();
    }
    String _plus_2 = (_plus_1 + _name_1);
    String _plus_3 = (_plus_2 + ": ");
    Assert.assertEquals(_plus_3, expectedStrategy, ptrs.getTypingStrategy());
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _hasElements = false;
      for(final Pair<String, String> p : pairs) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(",", "");
        }
        String _value = p.getValue();
        _builder.append(_value);
        _builder.append(" ");
        String _key = p.getKey();
        _builder.append(_key);
      }
    }
    String expected = _builder.toString();
    StringConcatenation _builder_1 = new StringConcatenation();
    {
      Iterable<TField> _filter = Iterables.<TField>filter(ptrs.getStructuralMembers(), TField.class);
      boolean _hasElements_1 = false;
      for(final TField m : _filter) {
        if (!_hasElements_1) {
          _hasElements_1 = true;
        } else {
          _builder_1.appendImmediate(",", "");
        }
        TypeRef _typeRef = m.getTypeRef();
        String _typeRefAsString = null;
        if (_typeRef!=null) {
          _typeRefAsString=_typeRef.getTypeRefAsString();
        }
        _builder_1.append(_typeRefAsString);
        _builder_1.append(" ");
        String _name_2 = m.getName();
        _builder_1.append(_name_2);
      }
    }
    String actual = _builder_1.toString();
    Assert.assertEquals(expected, actual);
  }
  
  public void assertAdditionalFieldsThis(final TypingStrategy expectedStrategy, final List<Pair<String, String>> pairs, final TypeRef ref) {
    this.<ThisTypeRefStructural>assertType(ThisTypeRefStructural.class, ref);
    final ThisTypeRefStructural ptrs = ((ThisTypeRefStructural) ref);
    String _name = expectedStrategy.getName();
    String _plus = ("Expected " + _name);
    String _plus_1 = (_plus + " but was ");
    TypingStrategy _typingStrategy = ptrs.getTypingStrategy();
    String _name_1 = null;
    if (_typingStrategy!=null) {
      _name_1=_typingStrategy.getName();
    }
    String _plus_2 = (_plus_1 + _name_1);
    String _plus_3 = (_plus_2 + ": ");
    Assert.assertEquals(_plus_3, expectedStrategy, ptrs.getTypingStrategy());
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _hasElements = false;
      for(final Pair<String, String> p : pairs) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(",", "");
        }
        String _value = p.getValue();
        _builder.append(_value);
        _builder.append(" ");
        String _key = p.getKey();
        _builder.append(_key);
      }
    }
    String expected = _builder.toString();
    StringConcatenation _builder_1 = new StringConcatenation();
    {
      Iterable<TField> _filter = Iterables.<TField>filter(ptrs.getStructuralMembers(), TField.class);
      boolean _hasElements_1 = false;
      for(final TField m : _filter) {
        if (!_hasElements_1) {
          _hasElements_1 = true;
        } else {
          _builder_1.appendImmediate(",", "");
        }
        TypeRef _typeRef = m.getTypeRef();
        String _typeRefAsString = null;
        if (_typeRef!=null) {
          _typeRefAsString=_typeRef.getTypeRefAsString();
        }
        _builder_1.append(_typeRefAsString);
        _builder_1.append(" ");
        String _name_2 = m.getName();
        _builder_1.append(_name_2);
      }
    }
    String actual = _builder_1.toString();
    Assert.assertEquals(expected, actual);
  }
  
  public <T extends Object> T assertType(final Class<T> type, final Object obj) {
    String _simpleName = type.getSimpleName();
    String _plus = ("Expected type " + _simpleName);
    String _plus_1 = (_plus + " but got ");
    String _simpleName_1 = obj.getClass().getSimpleName();
    String _plus_2 = (_plus_1 + _simpleName_1);
    Assert.assertTrue(_plus_2, type.isInstance(obj));
    return ((T) obj);
  }
}
