/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js;

import org.eclipse.n4js.JSActivationUtil;
import org.eclipse.n4js.JSLibSingleTestConfig;
import org.eclipse.n4js.TestCodeProvider;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public abstract class AbstractJSLibTest {
    protected final JSLibSingleTestConfig config;
    @Rule
    public TestRule blackListHandler = new TestRule(){

        public Statement apply(Statement base, Description description) {
            if (AbstractJSLibTest.this.config.isBlackList()) {
                return new BlackListStatement(base);
            }
            return base;
        }
    };

    protected AbstractJSLibTest(JSLibSingleTestConfig config) {
        this.config = config;
        JSActivationUtil.enableJSSupport();
    }

    final class BlackListStatement
    extends Statement {
        private final Statement base;

        BlackListStatement(Statement base) {
            this.base = base;
        }

        public void evaluate() throws Throwable {
            try {
                this.base.evaluate();
            }
            catch (AssertionError e) {
                return;
            }
            String code = TestCodeProvider.getContentsFromFileEntry(AbstractJSLibTest.this.config.entry, AbstractJSLibTest.this.config.resourceName);
            Assert.assertEquals((String)"BLACKLISTS OUT OF SYNC\nExpected test to fail but succeeded", (Object)code, (Object)AbstractJSLibTest.this.config.entry.getName());
        }
    }
}

