/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js;

import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import org.eclipse.n4js.JSLibSingleTestConfig;

public class JSLibSingleTestConfigProvider {
    public static final String BLACKLIST_LINECOMMENT = "#";
    protected Set<String> blacklist;

    public JSLibSingleTestConfigProvider(String ... blacklistFileNames) throws IOException {
        this.blacklist = JSLibSingleTestConfigProvider.readModifierFiles(blacklistFileNames);
    }

    public JSLibSingleTestConfig createConfig(ZipEntry entry, String resourceName) {
        String entryName = entry.getName();
        String modifier = this.blacklist.contains(entryName) ? "blacklist" : null;
        return new JSLibSingleTestConfig(entry, resourceName, modifier);
    }

    protected static Set<String> readModifierFiles(String ... blacklistFileNames) throws IOException {
        HashSet<String> blacklist = new HashSet<String>();
        if (blacklistFileNames != null) {
            String[] stringArray = blacklistFileNames;
            int n = blacklistFileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String blacklistFileName = stringArray[n2];
                Iterable entries = Iterables.filter(JSLibSingleTestConfigProvider.getFileLines(blacklistFileName), (Predicate)new Predicate<String>(){

                    public boolean apply(String s) {
                        return !s.startsWith(JSLibSingleTestConfigProvider.BLACKLIST_LINECOMMENT) && !s.trim().isEmpty();
                    }
                });
                for (String entry : entries) {
                    if (blacklist.add(entry)) continue;
                    System.err.println("Duplicate blacklist entry: " + entry);
                }
                ++n2;
            }
        }
        return blacklist;
    }

    private static List<String> getFileLines(final String resourceName) throws IOException {
        ByteSource byteSource = new ByteSource(){

            public InputStream openStream() throws IOException {
                return Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
            }
        };
        CharSource charSrc = byteSource.asCharSource(Charsets.UTF_8);
        return charSrc.readLines();
    }
}

