/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.analysis;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.InputStream;
import java.util.ArrayList;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.Token;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.SmokeTestWriter;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.parser.antlr.lexer.InternalN4JSLexer;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.SyntheticCompositeNode;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.util.StringInputStream;

public abstract class AbstractSmokeTester {
    private final Provider<? extends Lexer> lexerProvider = new Provider<Lexer>(){

        public Lexer get() {
            return new InternalN4JSLexer(null);
        }
    };
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;

    public void assertNoException(CharSequence expression) throws Exception {
        boolean old = SmokeTestWriter.active;
        SmokeTestWriter.active = false;
        try {
            this.skipLastCharacters(expression);
            this.skipFirstCharacters(expression);
            this.skipCharactersInBetween(expression);
            this.skipThreeCharactersInBetween(expression);
            this.skipTokensInBetween(expression);
            this.skipNodesInBetween(expression);
        }
        finally {
            SmokeTestWriter.active = old;
        }
    }

    private void skipLastCharacters(CharSequence input) throws Exception {
        String string = input.toString();
        int i = 0;
        while (i < input.length()) {
            this.processFile(string.substring(0, i));
            ++i;
        }
    }

    private void skipFirstCharacters(CharSequence input) throws Exception {
        String string = input.toString();
        int i = 0;
        while (i < input.length()) {
            this.processFile(string.substring(i));
            ++i;
        }
    }

    private void skipCharactersInBetween(CharSequence input) throws Exception {
        String string = input.toString();
        if (input.length() > 1) {
            int i = 0;
            while (i < input.length() - 1) {
                this.processFile(String.valueOf(string.substring(0, i)) + string.substring(i + 1));
                ++i;
            }
        }
    }

    private void skipThreeCharactersInBetween(CharSequence input) throws Exception {
        String string = input.toString();
        if (input.length() > 4) {
            int i = 0;
            while (i < input.length() - 3) {
                this.processFile(String.valueOf(string.substring(0, i)) + string.substring(i + 3));
                ++i;
            }
        }
    }

    private void skipTokensInBetween(CharSequence input) throws Exception {
        String string = input.toString();
        ArrayList tokenList = Lists.newArrayList();
        Lexer lexer = (Lexer)this.lexerProvider.get();
        lexer.setCharStream((CharStream)new ANTLRStringStream(string));
        Token token = lexer.nextToken();
        while (token != Token.EOF_TOKEN) {
            tokenList.add((CommonToken)token);
            token = lexer.nextToken();
        }
        for (CommonToken token2 : tokenList) {
            int start = token2.getStartIndex();
            int length = token2.getText().length();
            this.processFile(String.valueOf(string.substring(0, start)) + string.substring(start + length));
        }
    }

    private void skipNodesInBetween(CharSequence input) throws Exception {
        String string = input.toString();
        Script script = this.completeScript(string);
        if (script != null) {
            XtextResource resource = (XtextResource)script.eResource();
            ICompositeNode rootNode = resource.getParseResult().getRootNode();
            ReplaceRegion region = null;
            for (INode node : rootNode.getAsTreeIterable()) {
                if (!(node instanceof ICompositeNode) || node instanceof SyntheticCompositeNode) continue;
                ICompositeNode casted = (ICompositeNode)node;
                int offset = node.getTotalOffset();
                int length = node.getTotalLength();
                if (length == 0 || !casted.getFirstChild().equals(casted.getLastChild()) || region != null && region.getOffset() == offset && region.getLength() == length) continue;
                region = new ReplaceRegion(offset, length, "");
                StringBuilder builder = new StringBuilder(rootNode.getText());
                region.applyTo(builder);
                this.processFile(builder.toString());
            }
        }
    }

    private Script completeScript(String string) throws Exception {
        Resource resource = this.newResourceSet().createResource(URI.createURI((String)"sample.js"));
        try (StringInputStream stream = new StringInputStream(string);){
            Script script;
            resource.load((InputStream)stream, null);
            Script script2 = script = (Script)resource.getContents().get(0);
            return script2;
        }
    }

    protected XtextResourceSet newResourceSet() {
        return (XtextResourceSet)this.resourceSetProvider.get();
    }

    protected abstract void processFile(String var1) throws Exception;
}

