/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.analysis;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.xtext.diagnostics.ExceptionDiagnostic;

public abstract class BaseAnalyser {
    protected final Logger logger;
    protected final boolean logCode;

    public BaseAnalyser(Logger logger) {
        this(logger, false);
    }

    public BaseAnalyser(Logger logger, boolean logCode) {
        this.logger = logger;
        this.logCode = logCode;
    }

    protected StringBuilder aggregateDiagnosticsToStringBuilder(String codeName, List<Resource.Diagnostic> issues) {
        StringBuilder result = new StringBuilder(codeName).append('\n');
        for (Resource.Diagnostic diagnostic : issues) {
            if (diagnostic instanceof ExceptionDiagnostic) {
                ((ExceptionDiagnostic)diagnostic).getException().printStackTrace();
            }
            result.append(" - line: " + diagnostic.getLine() + ", message: " + diagnostic.getMessage() + "\n");
        }
        return result;
    }

    protected List<Resource.Diagnostic> getScriptErrors(Script script) {
        return script.eResource().getErrors();
    }
}

