/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.analysis;

import com.google.common.base.Strings;
import com.google.common.io.CharStreams;
import com.google.common.io.LineProcessor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.analysis.Analyser;
import org.eclipse.n4js.analysis.BaseAnalyser;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.xtext.testing.serializer.SerializerTestHelper;
import org.junit.Assert;

public class PositiveAnalyser
extends BaseAnalyser
implements Analyser {
    protected final SerializerTestHelper serializerTester;

    public PositiveAnalyser(Logger logger, SerializerTestHelper serializerTester) {
        super(logger);
        this.serializerTester = serializerTester;
    }

    @Override
    public void analyse(Script script, String codeName, String code) {
        List<Resource.Diagnostic> errors = null;
        try {
            errors = this.getScriptErrors(script);
        }
        catch (Throwable t) {
            StringWriter writer = new StringWriter();
            t.printStackTrace(new PrintWriter(writer));
            Assert.assertEquals((Object)code, (Object)writer.toString());
            return;
        }
        if (!errors.isEmpty()) {
            String msg = "expected no errors in " + codeName + " but I got : " + errors.size();
            if (this.logger.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder(msg).append("\n");
                sb.append("========== " + codeName + " ==========\n");
                if (this.logCode) {
                    sb.append(code).append("\n");
                }
                sb.append(">>>> errors: ").append("\n");
                sb.append((CharSequence)this.aggregateDiagnosticsToStringBuilder(codeName, errors));
                sb.append(">>>> warnings: ").append("\n");
                sb.append("<<<<").append("\n");
                sb.append("========================================").append("\n");
                this.logger.debug((Object)sb);
            }
            Assert.assertEquals((String)msg, (Object)this.withLineNumbers(code), (Object)this.aggregateDiagnosticsToStringBuilder(codeName, errors).toString());
        }
    }

    private String withLineNumbers(String code) {
        try {
            return (String)CharStreams.readLines((Readable)new StringReader(code), (LineProcessor)new LineProcessor<String>(){
                private final StringBuilder lines = new StringBuilder();
                private int lineNo = 1;

                public boolean processLine(String line) throws IOException {
                    this.lines.append(Strings.padStart((String)String.valueOf(this.lineNo++), (int)3, (char)' ')).append(": ").append(line).append("\n");
                    return true;
                }

                public String getResult() {
                    return this.lines.toString();
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    @Override
    public boolean isNegative() {
        return false;
    }
}

