/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tests.issues;

import com.google.common.base.Joiner;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.tests.issues.IssuePropertyEqualsMatcher;
import org.eclipse.n4js.tests.issues.IssuePropertyMatcher;
import org.eclipse.n4js.tests.issues.StringPropertyMatcherBuilder;
import org.eclipse.n4js.tests.issues.URIPropertyMatcherBuilder;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.Issue;

public class IssueMatcher {
    private final List<IssuePropertyMatcher> propertyMatchers = new LinkedList<IssuePropertyMatcher>();

    public IssueMatcher severity(Severity expectedSeverity) {
        return this.addEqualsMatcher("severity", expectedSeverity, issue -> issue.getSeverity());
    }

    public IssueMatcher error() {
        return this.severity(Severity.ERROR);
    }

    public IssueMatcher warning() {
        return this.severity(Severity.WARNING);
    }

    public IssueMatcher info() {
        return this.severity(Severity.INFO);
    }

    public StringPropertyMatcherBuilder message() {
        return new StringPropertyMatcherBuilder(this, "message", issue -> issue.getMessage());
    }

    public IssueMatcher message(String expectedMessage) {
        return this.message().equals(expectedMessage);
    }

    public StringPropertyMatcherBuilder code() {
        return new StringPropertyMatcherBuilder(this, "code", issue -> issue.getCode());
    }

    public IssueMatcher code(String expectedCode) {
        return this.code().equals(expectedCode);
    }

    public IssueMatcher type(CheckType expectedType) {
        return this.addEqualsMatcher("type", expectedType, issue -> issue.getType());
    }

    public URIPropertyMatcherBuilder uri() {
        return new URIPropertyMatcherBuilder(this, "URI", issue -> issue.getUriToProblem());
    }

    public IssueMatcher lineNumber(int expectedLineNumber) {
        return this.addEqualsMatcher("line number", expectedLineNumber, issue -> issue.getLineNumber());
    }

    public IssueMatcher column(int expectedColumn) {
        return this.addEqualsMatcher("column", expectedColumn, issue -> issue.getColumn());
    }

    public IssueMatcher at(int expectedLineNumber, int expectedColumn) {
        return this.lineNumber(expectedLineNumber).column(expectedColumn);
    }

    public IssueMatcher at(URI expectedURISuffix, int expectedLineNumber, int expectedColumn) {
        return this.lineNumber(expectedLineNumber).column(expectedColumn).uri().endsWith(expectedURISuffix);
    }

    public IssueMatcher at(String expectedURISuffix, int expectedLineNumber, int expectedColumn) {
        return this.at(URI.createFileURI((String)expectedURISuffix), expectedLineNumber, expectedColumn);
    }

    public IssueMatcher offset(int expectedOffset) {
        return this.addEqualsMatcher("offset", expectedOffset, issue -> issue.getOffset());
    }

    public IssueMatcher length(int expectedLength) {
        return this.addEqualsMatcher("length", expectedLength, issue -> issue.getLength());
    }

    public IssueMatcher syntaxError(boolean syntaxError) {
        return this.addEqualsMatcher("syntax error", syntaxError, issue -> issue.isSyntaxError());
    }

    private <T> IssueMatcher addEqualsMatcher(String propertyName, T expectedValue, Function<Issue, T> getActualValue) {
        return this.addPropertyMatcher(new IssuePropertyEqualsMatcher<T>(propertyName, expectedValue, getActualValue));
    }

    IssueMatcher addPropertyMatcher(IssuePropertyMatcher propertyMatcher) {
        this.propertyMatchers.add(Objects.requireNonNull(propertyMatcher));
        return this;
    }

    public boolean matches(Issue issue) {
        Objects.requireNonNull(issue);
        for (IssuePropertyMatcher propertyMatcher : this.propertyMatchers) {
            if (propertyMatcher.matches(issue)) continue;
            return false;
        }
        return true;
    }

    public List<String> explainMismatch(Issue issue) {
        Objects.requireNonNull(issue);
        LinkedList<String> result = new LinkedList<String>();
        for (IssuePropertyMatcher propertyMatcher : this.propertyMatchers) {
            if (propertyMatcher.matches(issue)) continue;
            result.add(propertyMatcher.getMessage(issue));
        }
        return result;
    }

    public String getDescription() {
        return Joiner.on((String)", ").join(this.propertyMatchers.stream().map(matcher -> matcher.getDescription()).iterator());
    }

    public String toString() {
        return this.getDescription();
    }
}

