/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tests.issues;

import java.util.Objects;
import java.util.function.Function;
import org.eclipse.n4js.tests.issues.IssueMatcher;
import org.eclipse.n4js.tests.issues.IssuePropertyMatcherBuilder;
import org.eclipse.n4js.tests.issues.StringPropertyMatcher;
import org.eclipse.xtext.validation.Issue;

public class StringPropertyMatcherBuilder
extends IssuePropertyMatcherBuilder {
    private final Function<Issue, String> getActualValue;

    public StringPropertyMatcherBuilder(IssueMatcher matcher, String propertyName, Function<Issue, String> getActualValue) {
        super(matcher, propertyName);
        this.getActualValue = Objects.requireNonNull(getActualValue);
    }

    public IssueMatcher startsWith(String expectedPrefix) {
        return this.addPropertyMatcher(StringPropertyMatcher.Mode.StartsWith, false, expectedPrefix);
    }

    public IssueMatcher endsWith(String expectedSuffix) {
        return this.addPropertyMatcher(StringPropertyMatcher.Mode.EndsWith, false, expectedSuffix);
    }

    public IssueMatcher equals(String expectedValue) {
        return this.addPropertyMatcher(StringPropertyMatcher.Mode.Equals, false, expectedValue);
    }

    private IssueMatcher addPropertyMatcher(StringPropertyMatcher.Mode mode, boolean ignoreCase, String expectedPattern) {
        return this.addPropertyMatcher(new StringPropertyMatcher(this.getPropertyName(), mode, ignoreCase, expectedPattern, this.getActualValue));
    }
}

