/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tests.parser;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.N4JSInjectorProvider;
import org.eclipse.n4js.N4JSParseHelper;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.ParenExpression;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.testing.InjectWith;
import org.eclipse.xtext.testing.XtextRunner;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.junit.Assert;
import org.junit.runner.RunWith;

@RunWith(value=XtextRunner.class)
@InjectWith(value=N4JSInjectorProvider.class)
public abstract class AbstractParserTest
extends Assert {
    @Inject
    @Extension
    protected N4JSParseHelper _n4JSParseHelper;

    protected Script parseJSSuccessfully(CharSequence js) {
        try {
            Script script = this._n4JSParseHelper.parseUnrestricted(js);
            Functions.Function1 _function = it -> {
                int _line = it.getLine();
                String _plus = Integer.valueOf(_line) + ": ";
                String _message = it.getMessage();
                return String.valueOf(_plus) + _message;
            };
            Assert.assertTrue((String)IterableExtensions.join((Iterable)script.eResource().getErrors(), (CharSequence)"\n", (Functions.Function1)_function), (boolean)script.eResource().getErrors().isEmpty());
            return script;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected Script parseJSWithError(CharSequence js) {
        try {
            Script script = this._n4JSParseHelper.parseUnrestricted(js);
            EList errors = script.eResource().getErrors();
            Assert.assertFalse((String)errors.toString(), (boolean)errors.isEmpty());
            return script;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected Script parseESSuccessfully(CharSequence js) {
        return this.parseJSSuccessfully(js);
    }

    protected Script parseESWithError(CharSequence js) {
        return this.parseJSWithError(js);
    }

    protected Script parseN4jsSuccessfully(CharSequence js) {
        try {
            Script script = this._n4JSParseHelper.parseN4js(js);
            Functions.Function1 _function = it -> {
                int _line = it.getLine();
                String _plus = Integer.valueOf(_line) + ": ";
                String _message = it.getMessage();
                return String.valueOf(_plus) + _message;
            };
            Assert.assertTrue((String)IterableExtensions.join((Iterable)script.eResource().getErrors(), (CharSequence)"\n", (Functions.Function1)_function), (boolean)script.eResource().getErrors().isEmpty());
            return script;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected Script parseN4jsWithError(CharSequence js) {
        try {
            Script script = this._n4JSParseHelper.parseN4js(js);
            EList errors = script.eResource().getErrors();
            Assert.assertFalse((String)errors.toString(), (boolean)errors.isEmpty());
            return script;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected Expression unwrap(Expression it) {
        boolean _matched = false;
        if (it instanceof ParenExpression) {
            _matched = true;
            return ((ParenExpression)it).getExpression();
        }
        Assert.fail((String)("Expected ParenExpression but got" + it));
        return null;
    }

    protected String getText(Expression it) {
        return NodeModelUtils.getTokenText((INode)NodeModelUtils.findActualNodeFor((EObject)it));
    }

    protected String getPropertyText(ParameterizedPropertyAccessExpression it) {
        return NodeModelUtils.getTokenText((INode)((INode)IterableExtensions.head((Iterable)NodeModelUtils.findNodesForFeature((EObject)it, (EStructuralFeature)N4JSPackage.Literals.PARAMETERIZED_PROPERTY_ACCESS_EXPRESSION__PROPERTY))));
    }
}

