/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tests.projectModel;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.tests.projectModel.AbstractProjectModelSetup;
import org.eclipse.xtext.testing.validation.ValidationTestHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractProjectModelTest {
    @Inject
    private ValidationTestHelper validationTestHelper;
    @Inject
    private Provider<ResourceSet> resourceSetProvider;
    public final String myProjectName = "myProject";
    protected URI myProjectURI;
    public final String libProjectName = "libProject";
    protected URI libProjectURI;
    private AbstractProjectModelSetup setup;

    protected abstract AbstractProjectModelSetup createSetup();

    public void setMyProjectURI(URI myProjectURI) {
        this.myProjectURI = myProjectURI;
    }

    public void setLibProjectURI(URI libProjectURI) {
        this.libProjectURI = libProjectURI;
    }

    @Before
    public void setUp() {
        this.setup = this.createSetup();
        this.createTempProjects();
        Assert.assertNotNull((Object)this.myProjectURI);
        Assert.assertNotNull((Object)this.libProjectURI);
    }

    private void validateTempProjects() throws IOException {
        this.validateProjectDescription(this.myProjectURI);
        this.validateProjectDescription(this.libProjectURI);
    }

    private void validateProjectDescription(URI projectLocation) throws IOException {
        ResourceSet resourceSet = (ResourceSet)this.resourceSetProvider.get();
        URI projectDescriptionURI = projectLocation.appendSegment("package.json");
        Resource projectDescriptionResource = resourceSet.createResource(projectDescriptionURI);
        projectDescriptionResource.load(Collections.emptyMap());
        try {
            this.validationTestHelper.assertNoErrors(projectDescriptionResource);
        }
        catch (AssertionError e) {
            throw new AssertionError((Object)("Project description file " + projectDescriptionURI.toString() + " did not validate: " + ((Throwable)((Object)e)).getMessage()));
        }
    }

    private void deleteTempProjects() {
        this.setup.deleteTempProjects();
    }

    private void createTempProjects() {
        this.setup.createTempProjects();
    }

    @After
    public void tearDown() {
        this.deleteTempProjects();
        this.setup = null;
        this.myProjectURI = null;
        this.libProjectURI = null;
    }

    @Test
    public void testSetup() throws IOException {
        Assert.assertEquals((Object)"myProject", (Object)this.myProjectURI.lastSegment());
        Assert.assertEquals((Object)"libProject", (Object)this.libProjectURI.lastSegment());
        this.validateTempProjects();
    }
}

