/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.ui.editor;

import com.google.common.base.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.n4JS.GenericDeclaration;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.PropertyNameOwner;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExpression;
import org.eclipse.n4js.ts.types.SyntaxRelatedTElement;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TStructMember;
import org.eclipse.n4js.ts.types.TStructMethod;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.xtext.resource.DefaultLocationInFileProvider;
import org.eclipse.xtext.resource.ILocationInFileProviderExtension;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class N4JSLocationInFileProvider extends DefaultLocationInFileProvider {
  @Override
  public ITextRegion getFullTextRegion(final EObject element) {
    return super.getFullTextRegion(this.convertToSource(element));
  }
  
  @Override
  public ITextRegion getFullTextRegion(final EObject owner, final EStructuralFeature feature, final int indexInList) {
    return super.getFullTextRegion(this.convertToSource(owner), feature, indexInList);
  }
  
  @Override
  public ITextRegion getSignificantTextRegion(final EObject element) {
    return super.getSignificantTextRegion(this.convertToSource(element));
  }
  
  @Override
  public ITextRegion getSignificantTextRegion(final EObject owner, final EStructuralFeature feature, final int indexInList) {
    return super.getSignificantTextRegion(this.convertToSource(owner), feature, indexInList);
  }
  
  @Override
  public ITextRegion getTextRegion(final EObject object, final EStructuralFeature feature, final int indexInList, final ILocationInFileProviderExtension.RegionDescription query) {
    return super.getTextRegion(this.convertToSource(object), feature, indexInList, query);
  }
  
  @Override
  public ITextRegion getTextRegion(final EObject object, final ILocationInFileProviderExtension.RegionDescription query) {
    return super.getTextRegion(this.convertToSource(object), query);
  }
  
  protected EObject convertToSource(final EObject element) {
    EObject _xblockexpression = null;
    {
      if ((element == null)) {
        return null;
      }
      EObject _switchResult = null;
      boolean _matched = false;
      if (element instanceof TypeVariable) {
        _matched=true;
        final EObject parentAST = this.convertToSource(((TypeVariable)element).eContainer());
        if ((((parentAST instanceof GenericDeclaration) || (parentAST instanceof TStructMethod)) || (parentAST instanceof FunctionTypeExpression))) {
          final String typeVarName = ((TypeVariable)element).getName();
          if (((typeVarName != null) && (typeVarName.trim().length() > 0))) {
            EList<TypeVariable> _switchResult_1 = null;
            boolean _matched_1 = false;
            if (parentAST instanceof GenericDeclaration) {
              _matched_1=true;
              _switchResult_1 = ((GenericDeclaration)parentAST).getTypeVars();
            }
            if (!_matched_1) {
              if (parentAST instanceof TStructMethod) {
                _matched_1=true;
                _switchResult_1 = ((TStructMethod)parentAST).getTypeVars();
              }
            }
            if (!_matched_1) {
              if (parentAST instanceof FunctionTypeExpression) {
                _matched_1=true;
                _switchResult_1 = ((FunctionTypeExpression)parentAST).getOwnedTypeVars();
              }
            }
            final EList<TypeVariable> typeVars = _switchResult_1;
            final Function1<TypeVariable, Boolean> _function = (TypeVariable it) -> {
              String _name = it.getName();
              return Boolean.valueOf(Objects.equal(_name, typeVarName));
            };
            final TypeVariable correspondingTypeVarInAST = IterableExtensions.<TypeVariable>findFirst(typeVars, _function);
            if ((correspondingTypeVarInAST != null)) {
              return correspondingTypeVarInAST;
            }
          }
        }
        return element;
      }
      if (!_matched) {
        if (element instanceof TFormalParameter) {
          EObject _astElement = ((TFormalParameter)element).getAstElement();
          boolean _tripleEquals = (_astElement == null);
          if (_tripleEquals) {
            _matched=true;
            _switchResult = element;
          }
        }
      }
      if (!_matched) {
        if (element instanceof TStructMember) {
          EObject _astElement = ((TStructMember)element).getAstElement();
          boolean _tripleEquals = (_astElement == null);
          if (_tripleEquals) {
            _matched=true;
            _switchResult = element;
          }
        }
      }
      if (!_matched) {
        if (element instanceof TMember) {
          boolean _isComposed = ((TMember)element).isComposed();
          if (_isComposed) {
            _matched=true;
            _switchResult = element;
          }
        }
      }
      if (!_matched) {
        if (element instanceof SyntaxRelatedTElement) {
          _matched=true;
          EObject _xblockexpression_1 = null;
          {
            EObject _astElement = ((SyntaxRelatedTElement)element).getAstElement();
            boolean _tripleEquals = (_astElement == null);
            if (_tripleEquals) {
              throw new IllegalStateException();
            }
            _xblockexpression_1 = ((SyntaxRelatedTElement)element).getAstElement();
          }
          _switchResult = _xblockexpression_1;
        }
      }
      if (!_matched) {
        _switchResult = element;
      }
      _xblockexpression = _switchResult;
    }
    return _xblockexpression;
  }
  
  @Override
  protected EStructuralFeature getIdentifierFeature(final EObject obj) {
    if ((obj instanceof PropertyNameOwner)) {
      return N4JSPackage.eINSTANCE.getPropertyNameOwner_DeclaredName();
    }
    return super.getIdentifierFeature(obj);
  }
}
