/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.ui.wizard.workspace;

import java.beans.PropertyChangeListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.utils.beans.PropertyChangeSupport;
import org.eclipse.xtext.xbase.lib.Pure;

/**
 * An abstract model for workspace wizard elements.
 */
@PropertyChangeSupport
@SuppressWarnings("all")
public class WorkspaceWizardModel {
  private IPath project = new Path("");
  
  private IPath sourceFolder = new Path("");
  
  private String moduleSpecifier = "";
  
  /**
   * Tries to extract as much information possible from a structured selection.
   * 
   * @param model
   *            The model
   * @param selection
   *            The selection
   * @param extractModuleFile
   *            {@code true} if the module file should be filled in as well, {@code false} otherwise
   * @param n4jsCore
   *            IN4JSCore implementation
   */
  public static String populateModelFromInitialSelection(final WorkspaceWizardModel model, final IStructuredSelection selection, final boolean extractModuleFile, final IN4JSCore n4jsCore) {
    String _xblockexpression = null;
    {
      final Object firstElement = selection.getFirstElement();
      String _xifexpression = null;
      if ((firstElement instanceof IResource)) {
        String _xblockexpression_1 = null;
        {
          IPath path = ((IResource)firstElement).getFullPath();
          if ((firstElement instanceof IFile)) {
            path = path.removeLastSegments(1);
          }
          final URI rootURI = URI.createURI("platform:/resource/");
          final URI pathURI = URI.createPlatformResourceURI(path.toString(), true);
          final IN4JSProject n4jsProject = n4jsCore.findProject(pathURI).orNull();
          String _xifexpression_1 = null;
          if (((null != n4jsProject) && n4jsProject.exists())) {
            String _xblockexpression_2 = null;
            {
              final URI projectUri = n4jsProject.getLocation();
              String _string = projectUri.deresolve(rootURI).toString();
              final Path projectPath = new Path(_string);
              model.setProject(projectPath);
              String _xifexpression_2 = null;
              boolean _equals = pathURI.equals(projectUri);
              boolean _not = (!_equals);
              if (_not) {
                String _xblockexpression_3 = null;
                {
                  final IN4JSSourceContainer sourceFolder = n4jsCore.findN4JSSourceContainer(pathURI).orNull();
                  String _xifexpression_3 = null;
                  if ((null != sourceFolder)) {
                    String _xblockexpression_4 = null;
                    {
                      final String sourceFolderPath = sourceFolder.getRelativeLocation();
                      Path _path = new Path(sourceFolderPath);
                      model.setSourceFolder(_path);
                      String _string_1 = sourceFolder.getLocation().deresolve(rootURI).toString();
                      final Path sourceFolderURI = new Path(_string_1);
                      String _string_2 = pathURI.deresolve(rootURI).toString();
                      final Path moduleSpecifierPath = new Path(_string_2);
                      final String moduleSpecifier = moduleSpecifierPath.makeRelativeTo(sourceFolderURI).toString();
                      boolean _isEmpty = moduleSpecifier.isEmpty();
                      boolean _not_1 = (!_isEmpty);
                      if (_not_1) {
                        model.setModuleSpecifier((moduleSpecifier + "/"));
                      }
                      String _xifexpression_4 = null;
                      if ((extractModuleFile && (firstElement instanceof IFile))) {
                        String _lastSegment = ((IResource)firstElement).getFullPath().removeFileExtension().lastSegment();
                        String _plus = (model.moduleSpecifier + _lastSegment);
                        _xifexpression_4 = model.moduleSpecifier = _plus;
                      }
                      _xblockexpression_4 = _xifexpression_4;
                    }
                    _xifexpression_3 = _xblockexpression_4;
                  }
                  _xblockexpression_3 = _xifexpression_3;
                }
                _xifexpression_2 = _xblockexpression_3;
              }
              _xblockexpression_2 = _xifexpression_2;
            }
            _xifexpression_1 = _xblockexpression_2;
          }
          _xblockexpression_1 = _xifexpression_1;
        }
        _xifexpression = _xblockexpression_1;
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  private final java.beans.PropertyChangeSupport _propertyChangeSupport = new java.beans.PropertyChangeSupport(this);
  
  protected final java.beans.PropertyChangeSupport internalGetPropertyChangeSupport() {
    return this._propertyChangeSupport;
  }
  
  public final void addPropertyChangeListener(final PropertyChangeListener listener) {
    internalGetPropertyChangeSupport().addPropertyChangeListener(listener);
  }
  
  public final void removePropertyChangeListener(final PropertyChangeListener listener) {
    internalGetPropertyChangeSupport().removePropertyChangeListener(listener);
  }
  
  public final static String PROJECT_PROPERTY = "project";
  
  @Pure
  public IPath getProject() {
    return this.project;
  }
  
  public void setProject(final IPath project) {
    internalGetPropertyChangeSupport().firePropertyChange(PROJECT_PROPERTY, this.project, this.project = project);
  }
  
  public final static String SOURCE_FOLDER_PROPERTY = "sourceFolder";
  
  @Pure
  public IPath getSourceFolder() {
    return this.sourceFolder;
  }
  
  public void setSourceFolder(final IPath sourceFolder) {
    internalGetPropertyChangeSupport().firePropertyChange(SOURCE_FOLDER_PROPERTY, this.sourceFolder, this.sourceFolder = sourceFolder);
  }
  
  public final static String MODULE_SPECIFIER_PROPERTY = "moduleSpecifier";
  
  @Pure
  public String getModuleSpecifier() {
    return this.moduleSpecifier;
  }
  
  public void setModuleSpecifier(final String moduleSpecifier) {
    internalGetPropertyChangeSupport().firePropertyChange(MODULE_SPECIFIER_PROPERTY, this.moduleSpecifier, this.moduleSpecifier = moduleSpecifier);
  }
}
