/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.utils.resources;

import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFilterMatcherDescriptor;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.ISynchronizer;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.n4js.utils.resources.ProxyWorkspaceInvocationHandler;
import org.eclipse.xtend.lib.annotations.Delegate;
import org.eclipse.xtext.xbase.lib.Functions.Function0;

/**
 * Delegating {@link IWorkspace workspace} implementation, that simply delegates to the Eclipse workspace
 * if the {@link Platform platform} is running or delegates into a NOOP proxy workspace instance.
 */
@SuppressWarnings("all")
public class DelegatingWorkspace implements IWorkspace {
  @Delegate
  private final IWorkspace delegate = new Function0<IWorkspace>() {
    public IWorkspace apply() {
      IWorkspace _xifexpression = null;
      boolean _isRunning = Platform.isRunning();
      if (_isRunning) {
        _xifexpression = ResourcesPlugin.getWorkspace();
      } else {
        _xifexpression = ProxyWorkspaceInvocationHandler.createNewProxyWorkspace();
      }
      return _xifexpression;
    }
  }.apply();
  
  @Override
  public void checkpoint(final boolean build) {
  }
  
  public void addResourceChangeListener(final IResourceChangeListener arg0) {
    this.delegate.addResourceChangeListener(arg0);
  }
  
  public void addResourceChangeListener(final IResourceChangeListener arg0, final int arg1) {
    this.delegate.addResourceChangeListener(arg0, arg1);
  }
  
  public ISavedState addSaveParticipant(final Plugin arg0, final ISaveParticipant arg1) throws CoreException {
    return this.delegate.addSaveParticipant(arg0, arg1);
  }
  
  public ISavedState addSaveParticipant(final String arg0, final ISaveParticipant arg1) throws CoreException {
    return this.delegate.addSaveParticipant(arg0, arg1);
  }
  
  public void build(final int arg0, final IProgressMonitor arg1) throws CoreException {
    this.delegate.build(arg0, arg1);
  }
  
  public void build(final IBuildConfiguration[] arg0, final int arg1, final boolean arg2, final IProgressMonitor arg3) throws CoreException {
    this.delegate.build(arg0, arg1, arg2, arg3);
  }
  
  public IProject[][] computePrerequisiteOrder(final IProject[] arg0) {
    return this.delegate.computePrerequisiteOrder(arg0);
  }
  
  public IWorkspace.ProjectOrder computeProjectOrder(final IProject[] arg0) {
    return this.delegate.computeProjectOrder(arg0);
  }
  
  public IStatus copy(final IResource[] arg0, final IPath arg1, final boolean arg2, final IProgressMonitor arg3) throws CoreException {
    return this.delegate.copy(arg0, arg1, arg2, arg3);
  }
  
  public IStatus copy(final IResource[] arg0, final IPath arg1, final int arg2, final IProgressMonitor arg3) throws CoreException {
    return this.delegate.copy(arg0, arg1, arg2, arg3);
  }
  
  public IStatus delete(final IResource[] arg0, final boolean arg1, final IProgressMonitor arg2) throws CoreException {
    return this.delegate.delete(arg0, arg1, arg2);
  }
  
  public IStatus delete(final IResource[] arg0, final int arg1, final IProgressMonitor arg2) throws CoreException {
    return this.delegate.delete(arg0, arg1, arg2);
  }
  
  public void deleteMarkers(final IMarker[] arg0) throws CoreException {
    this.delegate.deleteMarkers(arg0);
  }
  
  public void forgetSavedTree(final String arg0) {
    this.delegate.forgetSavedTree(arg0);
  }
  
  public IFilterMatcherDescriptor[] getFilterMatcherDescriptors() {
    return this.delegate.getFilterMatcherDescriptors();
  }
  
  public IFilterMatcherDescriptor getFilterMatcherDescriptor(final String arg0) {
    return this.delegate.getFilterMatcherDescriptor(arg0);
  }
  
  public IProjectNatureDescriptor[] getNatureDescriptors() {
    return this.delegate.getNatureDescriptors();
  }
  
  public IProjectNatureDescriptor getNatureDescriptor(final String arg0) {
    return this.delegate.getNatureDescriptor(arg0);
  }
  
  public Map<IProject, IProject[]> getDanglingReferences() {
    return this.delegate.getDanglingReferences();
  }
  
  public IWorkspaceDescription getDescription() {
    return this.delegate.getDescription();
  }
  
  public IWorkspaceRoot getRoot() {
    return this.delegate.getRoot();
  }
  
  public IResourceRuleFactory getRuleFactory() {
    return this.delegate.getRuleFactory();
  }
  
  public ISynchronizer getSynchronizer() {
    return this.delegate.getSynchronizer();
  }
  
  public boolean isAutoBuilding() {
    return this.delegate.isAutoBuilding();
  }
  
  public boolean isTreeLocked() {
    return this.delegate.isTreeLocked();
  }
  
  public IProjectDescription loadProjectDescription(final IPath arg0) throws CoreException {
    return this.delegate.loadProjectDescription(arg0);
  }
  
  public IProjectDescription loadProjectDescription(final InputStream arg0) throws CoreException {
    return this.delegate.loadProjectDescription(arg0);
  }
  
  public IStatus move(final IResource[] arg0, final IPath arg1, final boolean arg2, final IProgressMonitor arg3) throws CoreException {
    return this.delegate.move(arg0, arg1, arg2, arg3);
  }
  
  public IStatus move(final IResource[] arg0, final IPath arg1, final int arg2, final IProgressMonitor arg3) throws CoreException {
    return this.delegate.move(arg0, arg1, arg2, arg3);
  }
  
  public IBuildConfiguration newBuildConfig(final String arg0, final String arg1) {
    return this.delegate.newBuildConfig(arg0, arg1);
  }
  
  public IProjectDescription newProjectDescription(final String arg0) {
    return this.delegate.newProjectDescription(arg0);
  }
  
  public void removeResourceChangeListener(final IResourceChangeListener arg0) {
    this.delegate.removeResourceChangeListener(arg0);
  }
  
  public void removeSaveParticipant(final Plugin arg0) {
    this.delegate.removeSaveParticipant(arg0);
  }
  
  public void removeSaveParticipant(final String arg0) {
    this.delegate.removeSaveParticipant(arg0);
  }
  
  public void run(final ICoreRunnable arg0, final ISchedulingRule arg1, final int arg2, final IProgressMonitor arg3) throws CoreException {
    this.delegate.run(arg0, arg1, arg2, arg3);
  }
  
  public void run(final ICoreRunnable arg0, final IProgressMonitor arg1) throws CoreException {
    this.delegate.run(arg0, arg1);
  }
  
  public void run(final IWorkspaceRunnable arg0, final ISchedulingRule arg1, final int arg2, final IProgressMonitor arg3) throws CoreException {
    this.delegate.run(arg0, arg1, arg2, arg3);
  }
  
  public void run(final IWorkspaceRunnable arg0, final IProgressMonitor arg1) throws CoreException {
    this.delegate.run(arg0, arg1);
  }
  
  public IStatus save(final boolean arg0, final IProgressMonitor arg1) throws CoreException {
    return this.delegate.save(arg0, arg1);
  }
  
  public void setDescription(final IWorkspaceDescription arg0) throws CoreException {
    this.delegate.setDescription(arg0);
  }
  
  public String[] sortNatureSet(final String[] arg0) {
    return this.delegate.sortNatureSet(arg0);
  }
  
  public IStatus validateEdit(final IFile[] arg0, final Object arg1) {
    return this.delegate.validateEdit(arg0, arg1);
  }
  
  public IStatus validateFiltered(final IResource arg0) {
    return this.delegate.validateFiltered(arg0);
  }
  
  public IStatus validateLinkLocation(final IResource arg0, final IPath arg1) {
    return this.delegate.validateLinkLocation(arg0, arg1);
  }
  
  public IStatus validateLinkLocationURI(final IResource arg0, final URI arg1) {
    return this.delegate.validateLinkLocationURI(arg0, arg1);
  }
  
  public IStatus validateName(final String arg0, final int arg1) {
    return this.delegate.validateName(arg0, arg1);
  }
  
  public IStatus validateNatureSet(final String[] arg0) {
    return this.delegate.validateNatureSet(arg0);
  }
  
  public IStatus validatePath(final String arg0, final int arg1) {
    return this.delegate.validatePath(arg0, arg1);
  }
  
  public IStatus validateProjectLocation(final IProject arg0, final IPath arg1) {
    return this.delegate.validateProjectLocation(arg0, arg1);
  }
  
  public IStatus validateProjectLocationURI(final IProject arg0, final URI arg1) {
    return this.delegate.validateProjectLocationURI(arg0, arg1);
  }
  
  public IPathVariableManager getPathVariableManager() {
    return this.delegate.getPathVariableManager();
  }
  
  public <T extends Object> T getAdapter(final Class<T> arg0) {
    return this.delegate.getAdapter(arg0);
  }
}
