/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.methods;

import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4idl.migrations.MigrationSwitchComputer;
import org.eclipse.n4js.n4idl.migrations.SwitchCondition;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.xpect.common.N4JSOffsetAdapter;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.expectation.IStringExpectation;
import org.eclipse.xpect.expectation.StringExpectation;
import org.eclipse.xpect.parameter.ParameterParser;
import org.eclipse.xpect.runner.Xpect;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

@XpectImport(value={N4JSOffsetAdapter.class})
public class TypeSwitchXpectMethod {
    @Inject
    private MigrationSwitchComputer switchComputer;
    @Inject
    private N4JSTypeSystem typeSystem;

    @ParameterParser(syntax="'of' arg1=OFFSET ")
    @Xpect
    public void typeSwitch(@StringExpectation IStringExpectation expectation, N4JSOffsetAdapter.IEObjectCoveringRegion arg1) {
        if (expectation == null) {
            throw new IllegalStateException("No expectation specified, add '--> <type switch string representation>'");
        }
        EObject object = arg1.getEObject();
        String typeSwitch = this.getTypeSwitch(object).toString();
        expectation.assertEquals((Object)String.format("\"%s\"", typeSwitch));
    }

    @ParameterParser(syntax="'of' arg1=OFFSET ")
    @Xpect
    public void typeSwitchTypeRef(@StringExpectation IStringExpectation expectation, N4JSOffsetAdapter.IEObjectCoveringRegion arg1) {
        if (expectation == null) {
            throw new IllegalStateException("No expectation specified, add '--> <type switch string representation>'");
        }
        EObject object = arg1.getEObject();
        String _xtrycatchfinallyexpression = null;
        try {
            _xtrycatchfinallyexpression = this.getTypeSwitchTypeRef(object).getTypeRefAsString();
        }
        catch (Throwable _t) {
            if (_t instanceof MigrationSwitchComputer.UnhandledTypeRefException) {
                _xtrycatchfinallyexpression = "unsupported";
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        String actual = _xtrycatchfinallyexpression;
        expectation.assertEquals((Object)String.format("\"%s\"", actual));
    }

    private TypeRef findTypeRefAtOffset(EObject offsetObject) {
        TypeRef firstContainedTypeRef = (TypeRef)IteratorExtensions.head((Iterator)Iterators.filter((Iterator)offsetObject.eAllContents(), TypeRef.class));
        if (firstContainedTypeRef == null) {
            throw new IllegalArgumentException("Failed to find a valid type reference at the given offset: " + offsetObject);
        }
        return firstContainedTypeRef;
    }

    private SwitchCondition getTypeSwitch(EObject offsetObject) {
        try {
            return this.switchComputer.compute(this.findTypeRefAtOffset(offsetObject));
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private TypeRef getTypeSwitchTypeRef(EObject offsetObject) {
        try {
            TypeRef contextTypeRef = this.findTypeRefAtOffset(offsetObject);
            SwitchCondition condition = this.switchComputer.compute(contextTypeRef);
            RuleEnvironment ruleEnv = this.typeSystem.createRuleEnvironmentForContext(contextTypeRef, contextTypeRef.eResource());
            return this.switchComputer.toTypeRef(ruleEnv, condition);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

