/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.methods.scoping;

import com.google.common.base.Function;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.ts.types.SyntaxRelatedTElement;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;

public class EObjectDescriptionToNameWithPositionMapper
implements Function<IEObjectDescription, String> {
    private static final String SEPARATOR = " - ";
    private final URI currentResourceURI;
    private final boolean withLineNumber;

    public EObjectDescriptionToNameWithPositionMapper(URI currentResourceURI, boolean withLineNumber) {
        this.currentResourceURI = currentResourceURI;
        this.withLineNumber = withLineNumber;
    }

    public String apply(IEObjectDescription desc) {
        return EObjectDescriptionToNameWithPositionMapper.descriptionToNameWithPosition(this.currentResourceURI, this.withLineNumber, desc);
    }

    public static String descriptionToNameWithPosition(URI currentURI, boolean withLineNumber, IEObjectDescription desc) {
        Resource eobjRes;
        URI uri;
        EObject syntaxElement;
        String name = desc.getName().toString();
        EObject eobj = desc.getEObjectOrProxy();
        if (eobj == null) {
            return "No EObject or proxy for " + name + " at URI " + desc.getEObjectURI();
        }
        String location = "";
        if (eobj instanceof SyntaxRelatedTElement && (syntaxElement = ((SyntaxRelatedTElement)eobj).getAstElement()) != null) {
            location = String.valueOf(location) + "T";
            eobj = syntaxElement;
        }
        URI uRI = uri = (eobjRes = eobj.eResource()) == null ? null : eobjRes.getURI();
        if (uri != currentURI && uri != null) {
            location = uri.lastSegment();
            if (eobj.eIsProxy() || withLineNumber) {
                location = String.valueOf(location) + ":";
            }
        }
        if (eobj.eIsProxy()) {
            URI proxyUri = desc.getEObjectURI();
            location = String.valueOf(location) + "proxy:" + EObjectDescriptionToNameWithPositionMapper.simpleURIString(proxyUri);
        } else if (withLineNumber) {
            ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)eobj);
            location = node == null ? String.valueOf(location) + "no node:" + EObjectDescriptionToNameWithPositionMapper.simpleURIString(desc.getEObjectURI()) : String.valueOf(location) + node.getStartLine();
        }
        return String.valueOf(name) + SEPARATOR + location;
    }

    static String simpleURIString(URI uri) {
        if (uri == null) {
            return "!!null!!";
        }
        return String.valueOf(uri.lastSegment()) + "#" + uri.fragment();
    }

    public static String getNameFromNameWithPosition(String nameWithPosition) {
        int index = nameWithPosition.indexOf(SEPARATOR);
        if (index > 0) {
            return nameWithPosition.substring(0, index);
        }
        return nameWithPosition;
    }

    public static String getPositionFromNameWithPosition(String nameWithPosition) {
        int index = nameWithPosition.indexOf(SEPARATOR);
        if (index >= 0) {
            return nameWithPosition.substring(index + SEPARATOR.length());
        }
        return "";
    }
}

