/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.methods.scoping;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.xpect.methods.scoping.IN4JSCommaSeparatedValuesExpectation;
import org.eclipse.n4js.xpect.methods.scoping.IsInScopeWithOptionalPositionPredicate;
import org.eclipse.n4js.xpect.methods.scoping.N4JSCommaSeparatedValuesExpectation;
import org.eclipse.n4js.xpect.methods.scoping.ScopeAwareIterable;
import org.eclipse.xpect.expectation.CommaSeparatedValuesExpectation;
import org.eclipse.xpect.expectation.ICommaSeparatedValuesExpectation;
import org.eclipse.xpect.parameter.ParameterParser;
import org.eclipse.xpect.runner.Xpect;
import org.eclipse.xpect.xtext.lib.tests.ScopingTest;
import org.eclipse.xpect.xtext.lib.util.XtextOffsetAdapter;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;

public class ScopeXpectMethod
extends ScopingTest {
    @Inject
    private IQualifiedNameConverter converter;
    @Inject
    private IScopeProvider scopeProvider;

    @Xpect
    @ParameterParser(syntax="('at' arg1=OFFSET)?")
    public void scopeWithPosition(@N4JSCommaSeparatedValuesExpectation IN4JSCommaSeparatedValuesExpectation expectation, XtextOffsetAdapter.ICrossEReferenceAndEObject arg1) {
        EObject eobj = arg1.getEObject();
        IScope scope = this.scopeProvider.getScope(eobj, arg1.getCrossEReference());
        for (IEObjectDescription eo : scope.getAllElements()) {
            eo.getEObjectURI();
        }
        URI uri = eobj == null ? null : (eobj.eResource() == null ? null : eobj.eResource().getURI());
        expectation.assertEquals(new ScopeAwareIterable(uri, true, scope), new IsInScopeWithOptionalPositionPredicate(this.converter, uri, true, scope));
    }

    @Xpect
    @ParameterParser(syntax="('at' arg1=OFFSET)?")
    public void scopeWithResource(@N4JSCommaSeparatedValuesExpectation IN4JSCommaSeparatedValuesExpectation expectation, XtextOffsetAdapter.ICrossEReferenceAndEObject arg1) {
        EObject eobj = arg1.getEObject();
        IScope scope = this.scopeProvider.getScope(eobj, arg1.getCrossEReference());
        for (IEObjectDescription eo : scope.getAllElements()) {
            eo.getEObjectURI();
        }
        URI uri = eobj == null ? null : (eobj.eResource() == null ? null : eobj.eResource().getURI());
        expectation.assertEquals(new ScopeAwareIterable(uri, false, scope), new IsInScopeWithOptionalPositionPredicate(this.converter, uri, false, scope));
    }

    @Xpect
    @ParameterParser(syntax="('at' arg1=OFFSET)?")
    public void scope(@CommaSeparatedValuesExpectation ICommaSeparatedValuesExpectation expectation, XtextOffsetAdapter.ICrossEReferenceAndEObject arg1) {
        EObject eobj = arg1.getEObject();
        IScope scope = this.scopeProvider.getScope(eobj, arg1.getCrossEReference());
        URI uri = eobj == null ? null : (eobj.eResource() == null ? null : eobj.eResource().getURI());
        expectation.assertEquals((Iterable)new ScopingTest.ScopeAllElements(scope), (Predicate)new IsInScopeWithOptionalPositionPredicate(this.converter, uri, false, scope));
    }

    @Xpect
    @ParameterParser(syntax="('at' arg1=OFFSET)?")
    public void binding(@CommaSeparatedValuesExpectation ICommaSeparatedValuesExpectation expectation, XtextOffsetAdapter.ICrossEReferenceAndEObject arg1) {
        IdentifiableElement element;
        EObject eobj = arg1.getEObject();
        ParameterizedPropertyAccessExpression ppae = (ParameterizedPropertyAccessExpression)EcoreUtil2.getContainerOfType((EObject)eobj, ParameterizedPropertyAccessExpression.class);
        if (ppae != null) {
            element = ppae.getProperty();
        } else if (eobj instanceof IdentifiableElement) {
            element = (IdentifiableElement)eobj;
        } else {
            throw new IllegalArgumentException("Cannot check binding for " + (eobj == null ? "null" : eobj.eClass().getName()));
        }
        String container = "";
        if (element instanceof TMember) {
            container = String.valueOf(((TMember)element).getContainingType().getName()) + ".";
        }
        String qn = String.valueOf(container) + element.getName();
        expectation.assertEquals(Collections.singleton(qn));
    }
}

