/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.json.ui.contentassist;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.n4js.json.ui.contentassist.AbstractJSONProposalProvider;
import org.eclipse.n4js.json.ui.contentassist.IJSONProposalProvider;
import org.eclipse.n4js.json.ui.contentassist.JSONProposalFactory;
import org.eclipse.n4js.json.ui.extension.JSONUiExtensionRegistry;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class JSONProposalProvider
extends AbstractJSONProposalProvider {
    @Inject
    private JSONUiExtensionRegistry registry;
    @Inject
    private JSONProposalFactory nameValuePairProposalFactory;

    @Override
    public void complete_JSONArray(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!context.getPrefix().isEmpty()) {
            return;
        }
        for (IJSONProposalProvider pe : this.registry.getProposalProviderExtensions()) {
            if (!pe.isResponsible(model)) continue;
            pe.complete_JSONArray(model, ruleCall, context, acceptor);
        }
        acceptor.accept((ICompletionProposal)new ConfigurableCompletionProposal("[]", context.getOffset(), 0, 1, null, JSONProposalFactory.createStyledString("[...]", "Array"), null, ""));
    }

    @Override
    public void complete_STRING(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (ruleCall.eContainer() instanceof Assignment && ((Assignment)ruleCall.eContainer()).getFeature().equals("name")) {
            return;
        }
        if (!context.getPrefix().isEmpty()) {
            return;
        }
        for (IJSONProposalProvider pe : this.registry.getProposalProviderExtensions()) {
            if (!pe.isResponsible(model)) continue;
            pe.complete_STRING(model, ruleCall, context, acceptor);
        }
        acceptor.accept((ICompletionProposal)new ConfigurableCompletionProposal("\"\"", context.getOffset(), 0, 1, null, JSONProposalFactory.createStyledString("\"...\"", "String"), null, ""));
    }

    public void completeKeyword(Keyword keyword, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (keyword.getValue().length() < 4) {
            return;
        }
        super.completeKeyword(keyword, context, acceptor);
    }

    @Override
    public void complete_JSONObject(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (!context.getPrefix().isEmpty()) {
            return;
        }
        for (IJSONProposalProvider pe : this.registry.getProposalProviderExtensions()) {
            if (!pe.isResponsible(model)) continue;
            pe.complete_JSONObject(model, ruleCall, context, acceptor);
        }
        acceptor.accept((ICompletionProposal)new ConfigurableCompletionProposal("{}", context.getOffset(), 0, 1, null, JSONProposalFactory.createStyledString("{...}", "Object"), null, ""));
    }

    @Override
    public void complete_NameValuePair(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        for (IJSONProposalProvider pe : this.registry.getProposalProviderExtensions()) {
            if (!pe.isResponsible(model)) continue;
            pe.complete_NameValuePair(model, ruleCall, context, acceptor);
        }
        if (!context.getPrefix().isEmpty()) {
            return;
        }
        acceptor.accept(this.nameValuePairProposalFactory.createGenericNameValueProposal(context));
        acceptor.accept(this.nameValuePairProposalFactory.createGenericNameArrayProposal(context));
        acceptor.accept(this.nameValuePairProposalFactory.createGenericNameObjectProposal(context));
    }
}

