/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.regex.tests;

import org.eclipse.xtend2.lib.StringConcatenation;
import org.junit.Assert;
import org.junit.Test;

@SuppressWarnings("all")
public abstract class AbstractExampleTests extends Assert {
  public abstract void assertValid(final CharSequence expression);
  
  @Test
  public void testSampleFromJSREGEXcom() {
    this.assertValid("/[Tt]he\\sr\\w+/");
  }
  
  @Test
  public void testFiveDigits() {
    this.assertValid("/^\\d{5}$/");
  }
  
  @Test
  public void testDigits_01() {
    this.assertValid("/\\d+/g");
  }
  
  @Test
  public void testDigits_02() {
    this.assertValid("/[\\(\\)-]/g");
  }
  
  @Test
  public void testCommaWithWS() {
    this.assertValid("/\\s*,\\s*/");
  }
  
  @Test
  public void testTwoWords() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/(\\w+)\\s(\\w+)/");
    this.assertValid(_builder);
  }
  
  @Test
  public void testTwoWords_02() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/(\\w.+)\\s(\\w.+)/");
    this.assertValid(_builder);
  }
  
  @Test
  public void testValidNumber() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/(^-*\\d+$)|(^-*\\d+\\.\\d+$)/");
    this.assertValid(_builder);
  }
  
  @Test
  public void testValidDateFormat() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/^\\d{1,2}(\\-|\\/|\\.)\\d{1,2}\\1\\d{4}$/");
    this.assertValid(_builder);
  }
  
  @Test
  public void testHtmlTags() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/(<)|(>)/g");
    this.assertValid(_builder);
  }
  
  @Test
  public void testSelfhtml() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/(http:\\/\\/\\S*)/g");
    this.assertValid(_builder);
  }
}
