/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.antlr;

import org.eclipse.xtext.xtext.generator.model.IXtextGeneratorFileSystemAccess;
import org.eclipse.xtext.xtext.generator.parser.antlr.AntlrGrammar;
import org.eclipse.xtext.xtext.generator.parser.antlr.KeywordHelper;
import org.eclipse.xtext.xtext.generator.parser.antlr.XtextAntlrGeneratorFragment2;

/**
 * Customization of the {@link XtextAntlrGeneratorFragment2} tweaking the tokens file handling.
 * The asymmetry in the tokens file handling for the runtime/production and contentAssist grammars
 * follows that of the former generator's fragments {@code org.eclipse.xtext.generator.parser.antlr.ex.rt.AntlrGeneratorFragment}
 * and {@code org.eclipse.xtext.generator.parser.antlr.ex.ca.ContentAssistParserGeneratorFragment}.
 */
@SuppressWarnings("all")
public class N4AntlrGeneratorFragment2 extends XtextAntlrGeneratorFragment2 {
  @Override
  protected void cleanupParserTokensFile(final AntlrGrammar lexerGrammar, final AntlrGrammar parserGrammar, final KeywordHelper helper, final IXtextGeneratorFileSystemAccess fsa) {
    IXtextGeneratorFileSystemAccess _srcGen = this.getProjectConfig().getRuntime().getSrcGen();
    boolean _tripleEquals = (fsa == _srcGen);
    if (_tripleEquals) {
      super.cleanupParserTokensFile(lexerGrammar, parserGrammar, helper, fsa);
    } else {
      IXtextGeneratorFileSystemAccess _srcGen_1 = this.getProjectConfig().getGenericIde().getSrcGen();
      boolean _tripleEquals_1 = (fsa == _srcGen_1);
      if (_tripleEquals_1) {
        super.normalizeTokens(fsa, parserGrammar.getTokensFileName());
      }
    }
  }
}
