/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.generation;

import com.google.inject.Binder;
import com.google.inject.binder.ScopedBindingBuilder;
import org.eclipse.n4js.generation.RegularExpressionGeneratorNaming;
import org.eclipse.n4js.serializer.StableOrderSyntacticSequencerPDAProvider;
import org.eclipse.xtext.serializer.analysis.SyntacticSequencerPDAProvider;
import org.eclipse.xtext.xtext.generator.DefaultGeneratorModule;
import org.eclipse.xtext.xtext.generator.XtextGeneratorNaming;

/**
 * A Guice {@link Module Module} for injecting customizations for the RegularExpression language
 * into the (new) Xtext language generator.
 */
@SuppressWarnings("all")
public class RegularExpressionGeneratorModule extends DefaultGeneratorModule {
  public ScopedBindingBuilder configureXtextGeneratorNaming(final Binder binder) {
    return binder.<XtextGeneratorNaming>bind(XtextGeneratorNaming.class).to(RegularExpressionGeneratorNaming.class);
  }
  
  public ScopedBindingBuilder configurePatchedSerializerGenerator(final Binder binder) {
    return binder.<SyntacticSequencerPDAProvider>bind(SyntacticSequencerPDAProvider.class).to(StableOrderSyntacticSequencerPDAProvider.class);
  }
}
