package org.eclipse.n4js.semver.validation;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.n4js.utils.NLS;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.xbase.lib.Functions.Function0;

@NLS(propertyFileName = "messages")
@SuppressWarnings("all")
public class SemverIssueCodes {
  private final static String BUNDLE_NAME = SemverIssueCodes.class.getPackage().getName() + ".messages";
  
  private final static ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME);
  
  private final static String INITIALIZER = new Function0<String>() {
        public String apply() {
          org.eclipse.osgi.util.NLS.initializeMessages(BUNDLE_NAME, SemverIssueCodes.class);
          return "";
        }
      }.apply();;
  
  private static String getString(final String key) {
    try {
    	String value = RESOURCE_BUNDLE.getString(key);
    	String[] parts = value.split(";;;");
    	return parts[1];
    } catch (MissingResourceException e) {
    	return '!' + key + '!';
    }
  }
  
  public static Severity getDefaultSeverity(final String key) {
    try {
    	String value = RESOURCE_BUNDLE.getString(key);
    	String[] parts = value.split(";;;");
    	String defaultSeverity = parts[0];
    	return Severity.valueOf(defaultSeverity.toUpperCase());
    } catch (MissingResourceException e) {
    	return null;
    }
  }
  
  public final static String SEMVER_TOO_MANY_COMPARATORS = "SEMVER_TOO_MANY_COMPARATORS";
  
  /**
   * Only zero or one comparator allowed.
   */
  public static String getMessageForSEMVER_TOO_MANY_COMPARATORS() {
    return org.eclipse.osgi.util.NLS.bind(getString(SEMVER_TOO_MANY_COMPARATORS), new Object [] {  });
  }
  
  public final static String SEMVER_TOO_MANY_NUMBERS = "SEMVER_TOO_MANY_NUMBERS";
  
  /**
   * Too many version parts. Semantic versions consist only of major, minor and patch.
   */
  public static String getMessageForSEMVER_TOO_MANY_NUMBERS() {
    return org.eclipse.osgi.util.NLS.bind(getString(SEMVER_TOO_MANY_NUMBERS), new Object [] {  });
  }
}
