/**
 * Copyright (c) 2018 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.n4idl.migrations;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.function.Consumer;
import org.eclipse.n4js.n4idl.migrations.SwitchCondition;

/**
 * A depth-first iterator for {@link SwitchCondition}s.
 */
@SuppressWarnings("all")
public class SwitchConditionIterator implements Iterator<SwitchCondition> {
  private Queue<SwitchCondition> queue = new ArrayDeque<SwitchCondition>();
  
  public SwitchConditionIterator(final SwitchCondition root) {
    this.queue.add(root);
  }
  
  @Override
  public boolean hasNext() {
    boolean _isEmpty = this.queue.isEmpty();
    return (!_isEmpty);
  }
  
  @Override
  public SwitchCondition next() {
    final SwitchCondition nextElement = this.queue.poll();
    if ((null == nextElement)) {
      throw new NoSuchElementException();
    }
    final Consumer<SwitchCondition> _function = (SwitchCondition it) -> {
      this.queue.add(it);
    };
    nextElement.subConditions().forEach(_function);
    return nextElement;
  }
}
