/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.transpiler.es.assistants;

import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import org.eclipse.n4js.n4JS.ArrowFunction;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.transpiler.TransformationAssistant;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.VoidType;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

@SuppressWarnings("all")
public class BlockAssistant extends TransformationAssistant {
  @Inject
  private N4JSTypeSystem ts;
  
  /**
   * Some assertions related to arrow functions that apply to several transformations and are
   * therefore factored out into this helper method.
   */
  public void assertArrowFunctionConditions() {
    final Function1<ArrowFunction, Boolean> _function = (ArrowFunction it) -> {
      ArrowFunction _originalASTNodeOfSameType = this.getState().tracer.<ArrowFunction>getOriginalASTNodeOfSameType(it, false);
      return Boolean.valueOf((_originalASTNodeOfSameType != null));
    };
    this.assertTrue(
      ("all arrow functions must have an original AST node " + 
        "(i.e. not allowed to add arrow functions programmatically in a transformation)"), 
      IteratorExtensions.<ArrowFunction>forall(Iterators.<ArrowFunction>filter(this.getState().im.eAllContents(), ArrowFunction.class), _function));
  }
  
  public final boolean needsReturnInsertionForBody(final ArrowFunction arrowFuncInIM) {
    final ArrowFunction origAST = this.getState().tracer.<ArrowFunction>getOriginalASTNodeOfSameType(arrowFuncInIM, true);
    boolean _isSingleExprImplicitReturn = origAST.isSingleExprImplicitReturn();
    boolean _not = (!_isSingleExprImplicitReturn);
    if (_not) {
      return false;
    }
    final Expression singleExpr = origAST.implicitReturnExpr();
    final TypeRef implicitReturnTypeRef = this.ts.type(this.getState().G, singleExpr);
    Type _declaredType = null;
    if (implicitReturnTypeRef!=null) {
      _declaredType=implicitReturnTypeRef.getDeclaredType();
    }
    VoidType _voidType = RuleEnvironmentExtensions.voidType(this.getState().G);
    boolean _tripleEquals = (_declaredType == _voidType);
    if (_tripleEquals) {
      return false;
    }
    return true;
  }
}
