/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.transpiler.es.transform;

import java.util.function.Consumer;
import org.eclipse.n4js.generator.GeneratorOption;
import org.eclipse.n4js.n4JS.ArrowFunction;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.TransformationDependency;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.es.transform.ArrowFunction_Part1_Transformation;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Part 2 of {@link ArrowFunction_Part1_Transformation}.
 */
@TransformationDependency.Optional(GeneratorOption.ArrowFunctions)
@TransformationDependency.Requires(ArrowFunction_Part1_Transformation.class)
@SuppressWarnings("all")
public class ArrowFunction_Part2_Transformation extends Transformation {
  @Override
  public void analyze() {
  }
  
  @Override
  public void assertPreConditions() {
  }
  
  @Override
  public void assertPostConditions() {
    this.assertTrue("No arrow-function left in IM", this.<ArrowFunction>collectNodes(this.getState().im, ArrowFunction.class, true).isEmpty());
  }
  
  @Override
  public void transform() {
    final Consumer<ArrowFunction> _function = (ArrowFunction it) -> {
      this.transformArrowFunction(it);
    };
    IterableExtensions.<ArrowFunction>toList(this.<ArrowFunction>collectNodes(this.getState().im, ArrowFunction.class, true)).forEach(_function);
  }
  
  /**
   * replace arrow-function by function-expression
   */
  private void transformArrowFunction(final ArrowFunction arrowFunc) {
    final FunctionExpression fe = TranspilerBuilderBlocks._FunExpr(arrowFunc.isAsync(), arrowFunc.getName(), ((FormalParameter[])Conversions.unwrapArray(arrowFunc.getFpars(), FormalParameter.class)), arrowFunc.getBody());
    final ParameterizedCallExpression thisBinder = TranspilerBuilderBlocks._CallExpr(
      TranspilerBuilderBlocks._PropertyAccessExpr(
        TranspilerBuilderBlocks._Parenthesis(fe), 
        this.getSymbolTableEntryForMember(RuleEnvironmentExtensions.functionType(this.getState().G), "bind", false, false, true)), 
      TranspilerBuilderBlocks._ThisLiteral());
    this.replace(arrowFunc, thisBinder, fe);
  }
}
