/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.ui.wizard.classifiers;

import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.n4js.N4JSGlobals;
import org.eclipse.n4js.ui.wizard.model.AccessModifier;
import org.eclipse.n4js.ui.wizard.model.ClassifierReference;
import org.eclipse.n4js.ui.wizard.workspace.WorkspaceWizardModel;
import org.eclipse.n4js.utils.beans.PropertyChangeSupport;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pure;

/**
 * Wizard model for N4JS classifiers.
 */
@PropertyChangeSupport
@SuppressWarnings("all")
public abstract class N4JSClassifierWizardModel extends WorkspaceWizardModel {
  private String name = "";
  
  private AccessModifier accessModifier = AccessModifier.PUBLIC;
  
  private boolean definitionFile;
  
  private boolean internal;
  
  private boolean n4jsAnnotated;
  
  private List<ClassifierReference> interfaces = CollectionLiterals.<ClassifierReference>newArrayList();
  
  /**
   * Computes the file location in which the class is going to be created according to the current model.
   * 
   * @return path of the location.
   */
  public IPath computeFileLocation() {
    String _xifexpression = null;
    if (this.definitionFile) {
      _xifexpression = N4JSGlobals.N4JSD_FILE_EXTENSION;
    } else {
      _xifexpression = N4JSGlobals.N4JS_FILE_EXTENSION;
    }
    final String extension = _xifexpression;
    return this.getProject().append(this.getSourceFolder()).append(this.getEffectiveModuleSpecifier()).addFileExtension(extension);
  }
  
  /**
   * Dependent on the set module specifier this method returns its identity or the module specifier concatenated with
   * the class name. (set module specifiers ending with a '/' character are interpreted as base path)
   * 
   * @return the effective module specifier.
   */
  public String getEffectiveModuleSpecifier() {
    final String effectiveModuleSpecifier = super.getModuleSpecifier();
    if ((effectiveModuleSpecifier.isEmpty() || (effectiveModuleSpecifier.lastIndexOf(IPath.SEPARATOR) == (effectiveModuleSpecifier.length() - 1)))) {
      return (effectiveModuleSpecifier + this.name);
    }
    return effectiveModuleSpecifier;
  }
  
  /**
   * Returns with the human readable name of the classifier. For instance interface or class.
   */
  public abstract String getClassifierName();
  
  public final static String NAME_PROPERTY = "name";
  
  @Pure
  public String getName() {
    return this.name;
  }
  
  public void setName(final String name) {
    internalGetPropertyChangeSupport().firePropertyChange(NAME_PROPERTY, this.name, this.name = name);
  }
  
  public final static String ACCESS_MODIFIER_PROPERTY = "accessModifier";
  
  @Pure
  public AccessModifier getAccessModifier() {
    return this.accessModifier;
  }
  
  public void setAccessModifier(final AccessModifier accessModifier) {
    internalGetPropertyChangeSupport().firePropertyChange(ACCESS_MODIFIER_PROPERTY, this.accessModifier, this.accessModifier = accessModifier);
  }
  
  public final static String DEFINITION_FILE_PROPERTY = "definitionFile";
  
  @Pure
  public boolean isDefinitionFile() {
    return this.definitionFile;
  }
  
  public void setDefinitionFile(final boolean definitionFile) {
    internalGetPropertyChangeSupport().firePropertyChange(DEFINITION_FILE_PROPERTY, this.definitionFile, this.definitionFile = definitionFile);
  }
  
  public final static String INTERNAL_PROPERTY = "internal";
  
  @Pure
  public boolean isInternal() {
    return this.internal;
  }
  
  public void setInternal(final boolean internal) {
    internalGetPropertyChangeSupport().firePropertyChange(INTERNAL_PROPERTY, this.internal, this.internal = internal);
  }
  
  public final static String N4JS_ANNOTATED_PROPERTY = "n4jsAnnotated";
  
  @Pure
  public boolean isN4jsAnnotated() {
    return this.n4jsAnnotated;
  }
  
  public void setN4jsAnnotated(final boolean n4jsAnnotated) {
    internalGetPropertyChangeSupport().firePropertyChange(N4JS_ANNOTATED_PROPERTY, this.n4jsAnnotated, this.n4jsAnnotated = n4jsAnnotated);
  }
  
  public final static String INTERFACES_PROPERTY = "interfaces";
  
  @Pure
  public List<ClassifierReference> getInterfaces() {
    return this.interfaces;
  }
  
  public void setInterfaces(final List<ClassifierReference> interfaces) {
    internalGetPropertyChangeSupport().firePropertyChange(INTERFACES_PROPERTY, new java.util.ArrayList(this.interfaces), this.interfaces = interfaces);
  }
  
  public void addInterfaces(final ClassifierReference elementInterfaces) {
    internalGetPropertyChangeSupport().firePropertyChange(
    	INTERFACES_PROPERTY,
    	new java.util.ArrayList(this.interfaces),
    	this.interfaces.add(elementInterfaces) ? this.interfaces : this.interfaces);
  }
  
  public void removeInterfaces(final ClassifierReference elementInterfaces) {
    internalGetPropertyChangeSupport().firePropertyChange(
    	INTERFACES_PROPERTY,
    	new java.util.ArrayList(this.interfaces),
    	this.interfaces.remove(elementInterfaces) ? this.interfaces : this.interfaces);
  }
}
